/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.cria.solrext.searchcomponents;

import de.kippdata.cria.solrext.utils.FormalFieldParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;

public class FormalFieldQueryModifier
extends SearchComponent {
    private final String QUERY = "q";
    private final String DESCRIPTION = "SearchComponent that modifies a query";
    private final String REF = "$Revision: 1.6 $";
    private Map<String, String> rawMap = new HashMap<String, String>();
    private FormalFieldParser fieldParser;
    private static final Logger log = Logger.getLogger(FormalFieldQueryModifier.class);

    public void init(NamedList args) {
        for (int i = 0; i < args.size(); ++i) {
            this.rawMap.put(args.getName(i), args.getVal(i).toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("[init]: Found argument " + args.getName(i) + " with value " + args.getVal(i)));
            }
            this.fieldParser = new FormalFieldParser(this.rawMap);
        }
    }

    public String getDescription() {
        return "SearchComponent that modifies a query";
    }

    public String getSource() {
        return null;
    }

    public String getSourceId() {
        return null;
    }

    public String getVersion() {
        return "$Revision: 1.6 $";
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        String queryString;
        log.debug((Object)"[prepare]: Start");
        SolrParams params = rb.req.getParams();
        if (params.get("q") != null) {
            log.debug((Object)("[prepare]: Transforming formal fields for query " + params.get("q")));
            queryString = this.fieldParser.parse(params.get("q"));
            log.debug((Object)("[prepare]: Transformed query is '" + queryString + "'"));
        } else {
            queryString = "*:* AND NOT (*:*)";
        }
        rb.setQueryString(queryString);
        log.debug((Object)"[prepare]: Done.");
    }
}

