#!/bin/bash

set -e

test -z "$1" && { echo "missing argument. please define new version number"; exit 1; }

VERSION=$1
BRANCH=$(git rev-parse --abbrev-ref HEAD)
FULLPATH=${PWD}
PRODUCT=${PWD##*/}

cd build
git checkout master
git pull
ant -f releaseNumbers.xml -DversionNumber=${VERSION} "-DreleaseNotes=prepare for ${VERSION} release" -DprojectSets=${PRODUCT}-packages loadProjectSets newVersion
cd ${FULLPATH}
git add build
find . -name MANIFEST.MF -type f -print -exec git add {} \;
find . -name changelog -type f -print -exec git add {} \;
find . -name '*.spec' -type f -print -exec git add {} \;
find . -maxdepth 2 -name package.json -type f -print -exec git add {} \;
git commit -m "prepare for ${VERSION} release"

