/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.calendar.itip;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link HRRStrings}
 *
 * @author <a href="mailto:martin.herfurth@open-xchange.com">Martin Herfurth</a>
 */
public class HRRStrings implements LocalizableStrings {

    public static final String NO = "No recurrence";

    public static final String DAILY = "Every %1$s day";

    public static final String WEEKLY_EACH = "Every week on %1$s";

    public static final String WEEKLY = "Every %1$s weeks on %2$s";

    public static final String MONTHLY_1 = "On %1$s. day every %2$s. month";

    public static final String MONTHLY_2 = "On %1$s %2$s every %3$s. month";

    public static final String YEARLY_1 = "On %1$s %2$s in %3$s";

    // E.g. "Every 2. February"
    public static final String YEARLY_2 = "Every %1$s. %2$s";

    public static final String WORK_DAY = "Work day";

    public static final String WEEKEND_DAY = "Weekend day";

    public static final String DAY = "Day";

    public static final String MONDAY = "Monday";

    public static final String TUESDAY = "Tuesday";

    public static final String WEDNESDAY = "Wednesday";

    public static final String THURSDAY = "Thursday";

    public static final String FRIDAY = "Friday";

    public static final String SATURDAY = "Saturday";

    public static final String SUNDAY = "Sunday";

    public static final String JANUARY = "January";

    public static final String FEBRUARY = "February";

    public static final String MARCH = "March";

    public static final String APRIL = "April";

    public static final String MAY = "May";

    public static final String JUNE = "June";

    public static final String JULY = "July";

    public static final String AUGUST = "August";

    public static final String SEPTEMBER = "September";

    public static final String OCTOBER = "October";

    public static final String NOVEMBER = "November";

    public static final String DECEMBER = "December";

    public static final String FIRST = "first";

    public static final String SECOND = "second";

    public static final String THIRD = "third";

    public static final String FOURTH = "fourth";

    public static final String LAST = "last";

    public static final String OCCURRENCES = "Occurs %1$s times";

    // E.g. "Until Wednesday, July 11, 2012"
    public static final String UNTIL = "Until %1$s";

    public static final String FOREVER = "No end";
}
