/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalAtomicNumberOperationStatsImpl;
import com.hazelcast.impl.monitor.LocalOperationStatsSupport;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalAtomicNumberOperationStats;

public class AtomicNumberOperationsCounter
extends OperationsCounterSupport<LocalAtomicNumberOperationStats> {
    private static final LocalAtomicNumberOperationStats empty = new LocalAtomicNumberOperationStatsImpl();
    private OperationsCounterSupport.OperationCounter modified = new OperationsCounterSupport.OperationCounter(this);
    private OperationsCounterSupport.OperationCounter nonModified = new OperationsCounterSupport.OperationCounter(this);

    public AtomicNumberOperationsCounter() {
    }

    public AtomicNumberOperationsCounter(long interval) {
        super(interval);
    }

    public void incrementModified(long elapsed) {
        this.modified.count(elapsed);
        this.publishSubResult();
    }

    public void incrementNonModified(long elapsed) {
        this.nonModified.count(elapsed);
        this.publishSubResult();
    }

    @Override
    LocalAtomicNumberOperationStats aggregateSubCounterStats() {
        LocalAtomicNumberOperationStatsImpl stats = new LocalAtomicNumberOperationStatsImpl();
        stats.periodStart = ((AtomicNumberOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        for (Object obj : this.listOfSubCounters) {
            AtomicNumberOperationsCounter sub = (AtomicNumberOperationsCounter)obj;
            stats.modified.add(sub.modified.count.get(), sub.modified.totalLatency.get());
            stats.nonModified.add(sub.nonModified.count.get(), sub.nonModified.totalLatency.get());
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    AtomicNumberOperationsCounter getAndReset() {
        AtomicNumberOperationsCounter newOne = new AtomicNumberOperationsCounter();
        newOne.modified.set(this.modified.copyAndReset());
        newOne.nonModified.set(this.nonModified.copyAndReset());
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    @Override
    LocalAtomicNumberOperationStats getThis() {
        LocalAtomicNumberOperationStatsImpl stats = new LocalAtomicNumberOperationStatsImpl();
        stats.periodStart = this.startTime;
        LocalAtomicNumberOperationStatsImpl localAtomicNumberOperationStatsImpl = stats;
        localAtomicNumberOperationStatsImpl.getClass();
        stats.modified = new LocalOperationStatsSupport.OperationStat(localAtomicNumberOperationStatsImpl, this.modified.count.get(), this.modified.totalLatency.get());
        LocalAtomicNumberOperationStatsImpl localAtomicNumberOperationStatsImpl2 = stats;
        localAtomicNumberOperationStatsImpl2.getClass();
        stats.nonModified = new LocalOperationStatsSupport.OperationStat(localAtomicNumberOperationStatsImpl2, this.nonModified.count.get(), this.nonModified.totalLatency.get());
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalAtomicNumberOperationStats getEmpty() {
        return empty;
    }
}

