/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.NearCacheRecord;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;

public class DefaultNearCacheRecord
implements NearCacheRecord {
    private final Data keyData;
    private Data valueData = null;
    private Object value = null;

    public DefaultNearCacheRecord(Data keyData, Data valueData) {
        this.keyData = keyData;
        this.valueData = valueData;
    }

    @Override
    public void setValueData(Data valueData) {
        this.valueData = valueData;
        this.value = null;
    }

    @Override
    public Data getValueData() {
        return this.valueData;
    }

    @Override
    public Data getKeyData() {
        return this.keyData;
    }

    @Override
    public boolean hasValueData() {
        return this.valueData != null;
    }

    @Override
    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (!this.hasValueData()) {
            return null;
        }
        this.value = IOUtil.toObject(this.valueData);
        return this.value;
    }

    @Override
    public void invalidate() {
        this.setValueData(null);
    }
}

