/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.Clock;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ResponseQueueFactory {
    public static BlockingQueue newResponseQueue() {
        return new LockBasedResponseQueue();
    }

    private static final class LockBasedResponseQueue
    extends AbstractQueue
    implements BlockingQueue {
        private Object response = null;
        private final Lock lock = new ReentrantLock();
        private final Condition noValue = this.lock.newCondition();
        private static final Object NULL = new Object();

        private LockBasedResponseQueue() {
        }

        public Object take() throws InterruptedException {
            this.lock.lock();
            try {
                while (this.response == null) {
                    this.noValue.await();
                }
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean offer(Object o, long timeout, TimeUnit unit) throws InterruptedException {
            return this.offer(o);
        }

        public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            long remaining = unit.toMillis(timeout);
            this.lock.lock();
            try {
                while (this.response == null && remaining > 0L) {
                    long start = Clock.currentTimeMillis();
                    this.noValue.await(remaining, TimeUnit.MILLISECONDS);
                    remaining -= Clock.currentTimeMillis() - start;
                }
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void put(Object o) throws InterruptedException {
            this.offer(o);
        }

        @Override
        public boolean offer(Object obj) {
            if (obj == null) {
                obj = NULL;
            }
            this.lock.lock();
            try {
                if (this.response != null) {
                    return false;
                }
                this.response = obj;
                this.noValue.signal();
                return true;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Object poll() {
            this.lock.lock();
            try {
                Object object = this.getAndRemoveResponse();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }

        private Object getAndRemoveResponse() {
            Object value = this.response;
            this.response = null;
            return value == NULL ? null : value;
        }

        @Override
        public int remainingCapacity() {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int drainTo(Collection c, int maxElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.lock.lock();
            try {
                this.response = null;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            this.lock.lock();
            try {
                int n = this.response == null ? 0 : 1;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Object peek() {
            this.lock.lock();
            try {
                Object object = this.response;
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

