/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.partition.DefaultMemberGroup;
import com.hazelcast.impl.partition.MemberGroup;
import com.hazelcast.impl.partition.MemberGroupFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

abstract class BackupSafeMemberGroupFactory
implements MemberGroupFactory {
    BackupSafeMemberGroupFactory() {
    }

    @Override
    public final Collection<MemberGroup> createMemberGroups(Collection<MemberImpl> allMembers) {
        Collection<MemberImpl> members = this.removeLiteMembers(allMembers);
        Set<MemberGroup> groups = this.createInternalMemberGroups(members);
        if (groups.size() == 1 && members.size() > 1) {
            MemberGroup group1 = (MemberGroup)groups.iterator().next();
            DefaultMemberGroup group2 = new DefaultMemberGroup();
            int sizePerGroup = group1.size() / 2;
            Iterator<MemberImpl> iter = group1.iterator();
            while (group2.size() < sizePerGroup && iter.hasNext()) {
                group2.addMember(iter.next());
                iter.remove();
            }
            groups.add(group2);
        }
        return groups;
    }

    protected abstract Set<MemberGroup> createInternalMemberGroups(Collection<MemberImpl> var1);

    private Collection<MemberImpl> removeLiteMembers(Collection<MemberImpl> members) {
        LinkedList<MemberImpl> result = new LinkedList<MemberImpl>();
        for (MemberImpl member : members) {
            if (member.isLiteMember()) continue;
            result.add(member);
        }
        return result;
    }
}

