/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalQueueOperationStatsImpl;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalQueueOperationStats;
import java.util.concurrent.atomic.AtomicLong;

public class QueueOperationsCounter
extends OperationsCounterSupport<LocalQueueOperationStats> {
    private static final LocalQueueOperationStats empty = new LocalQueueOperationStatsImpl();
    private AtomicLong offers = new AtomicLong();
    private AtomicLong rejectedOffers = new AtomicLong();
    private AtomicLong polls = new AtomicLong();
    private AtomicLong emptyPolls = new AtomicLong();
    private AtomicLong others = new AtomicLong();
    private AtomicLong events = new AtomicLong();

    public QueueOperationsCounter() {
    }

    public QueueOperationsCounter(long interval) {
        super(interval);
    }

    QueueOperationsCounter getAndReset() {
        QueueOperationsCounter newOne = new QueueOperationsCounter();
        newOne.offers.set(this.offers.getAndSet(0L));
        newOne.polls.set(this.polls.getAndSet(0L));
        newOne.rejectedOffers.set(this.rejectedOffers.getAndSet(0L));
        newOne.emptyPolls.set(this.emptyPolls.getAndSet(0L));
        newOne.others.set(this.others.getAndSet(0L));
        newOne.events.set(this.events.getAndSet(0L));
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    public void incrementOffers() {
        this.offers.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementRejectedOffers() {
        this.rejectedOffers.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementPolls() {
        this.polls.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementEmptyPolls() {
        this.emptyPolls.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementOtherOperations() {
        this.others.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReceivedEvents() {
        this.events.incrementAndGet();
        this.publishSubResult();
    }

    @Override
    LocalQueueOperationStats aggregateSubCounterStats() {
        LocalQueueOperationStatsImpl stats = new LocalQueueOperationStatsImpl();
        stats.periodStart = ((QueueOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        int i = 0;
        while (i < this.listOfSubCounters.size()) {
            QueueOperationsCounter sub = (QueueOperationsCounter)this.listOfSubCounters.get(i);
            stats.numberOfPolls += sub.polls.get();
            stats.numberOfOffers += sub.offers.get();
            stats.numberOfRejectedOffers += sub.rejectedOffers.get();
            stats.numberOfEmptyPolls += sub.emptyPolls.get();
            stats.numberOfOtherOperations += sub.others.get();
            stats.numberOfEvents += sub.events.get();
            stats.periodEnd = sub.endTime;
            ++i;
        }
        return stats;
    }

    @Override
    LocalQueueOperationStats getThis() {
        LocalQueueOperationStatsImpl stats = new LocalQueueOperationStatsImpl();
        stats.periodStart = this.startTime;
        stats.numberOfPolls = this.polls.get();
        stats.numberOfOffers = this.offers.get();
        stats.numberOfEmptyPolls = this.emptyPolls.get();
        stats.numberOfRejectedOffers = this.rejectedOffers.get();
        stats.numberOfEvents = this.events.get();
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalQueueOperationStats getEmpty() {
        return empty;
    }
}

