/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.impl.monitor.LocalExecutorOperationStatsImpl;
import com.hazelcast.impl.monitor.OperationsCounterSupport;
import com.hazelcast.monitor.LocalExecutorOperationStats;
import java.util.concurrent.atomic.AtomicLong;

public class ExecutorOperationsCounter
extends OperationsCounterSupport<LocalExecutorOperationStats> {
    private static final LocalExecutorOperationStats empty = new LocalExecutorOperationStatsImpl("");
    private final OperationsCounterSupport.OperationCounter executionStarts = new OperationsCounterSupport.OperationCounter(this);
    private final OperationsCounterSupport.OperationCounter executionEnds = new OperationsCounterSupport.OperationCounter(this);
    private final AtomicLong pending = new AtomicLong(0L);
    private final AtomicLong maxCompletionTime = new AtomicLong(Long.MIN_VALUE);
    private final AtomicLong minCompletionTime = new AtomicLong(Long.MAX_VALUE);
    private final String executorName;

    public ExecutorOperationsCounter(long interval, String name) {
        super(interval);
        this.executorName = name;
    }

    ExecutorOperationsCounter getAndReset() {
        OperationsCounterSupport.OperationCounter executionNow = this.executionStarts.copyAndReset();
        OperationsCounterSupport.OperationCounter waitNow = this.executionEnds.copyAndReset();
        long pendingNow = this.pending.get();
        long maxCompletion = this.maxCompletionTime.getAndSet(Long.MIN_VALUE);
        long minCompletion = this.minCompletionTime.getAndSet(Long.MAX_VALUE);
        ExecutorOperationsCounter newOne = new ExecutorOperationsCounter(this.interval, this.executorName);
        newOne.executionStarts.set(executionNow);
        newOne.executionEnds.set(waitNow);
        newOne.pending.set(pendingNow);
        newOne.maxCompletionTime.set(maxCompletion);
        newOne.minCompletionTime.set(minCompletion);
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    public void finishExecution(long elapsed) {
        this.executionEnds.count(elapsed);
        if (elapsed > this.maxCompletionTime.get()) {
            this.maxCompletionTime.set(elapsed);
        }
        if (elapsed < this.minCompletionTime.get()) {
            this.minCompletionTime.set(elapsed);
        }
        this.publishSubResult();
    }

    public void startExecution(long elapsed) {
        this.executionStarts.count(elapsed);
        this.pending.decrementAndGet();
        this.publishSubResult();
    }

    public void startPending() {
        this.pending.incrementAndGet();
        this.publishSubResult();
    }

    @Override
    LocalExecutorOperationStats aggregateSubCounterStats() {
        LocalExecutorOperationStatsImpl stats = new LocalExecutorOperationStatsImpl(this.executorName);
        stats.periodStart = ((ExecutorOperationsCounter)this.listOfSubCounters.get((int)0)).startTime;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        int i = 0;
        while (i < this.listOfSubCounters.size()) {
            ExecutorOperationsCounter sub = (ExecutorOperationsCounter)this.listOfSubCounters.get(i);
            if (sub.minCompletionTime.get() < min) {
                min = sub.minCompletionTime.get();
            }
            if (sub.maxCompletionTime.get() > max) {
                max = sub.maxCompletionTime.get();
            }
            stats.started.addAndGet(sub.executionStarts.count.get());
            stats.startLatency.addAndGet(sub.executionStarts.totalLatency.get());
            stats.completed.addAndGet(sub.executionEnds.count.get());
            stats.completionTime.addAndGet(sub.executionEnds.totalLatency.get());
            stats.periodEnd = sub.endTime;
            ++i;
        }
        stats.maxCompletionTime.set(max);
        stats.minCompletionTime.set(min);
        stats.pending.set(((ExecutorOperationsCounter)this.listOfSubCounters.get((int)(this.listOfSubCounters.size() - 1))).pending.get());
        return stats;
    }

    @Override
    LocalExecutorOperationStats getThis() {
        LocalExecutorOperationStatsImpl stats = new LocalExecutorOperationStatsImpl(this.executorName);
        stats.periodStart = this.startTime;
        stats.started.set(this.executionStarts.count.get());
        stats.startLatency.set(this.executionStarts.totalLatency.get());
        stats.completed.set(this.executionEnds.count.get());
        stats.completionTime.set(this.executionEnds.totalLatency.get());
        stats.maxCompletionTime.set(this.maxCompletionTime.get());
        stats.minCompletionTime.set(this.minCompletionTime.get());
        stats.periodEnd = this.now();
        return stats;
    }

    @Override
    LocalExecutorOperationStats getEmpty() {
        return empty;
    }
}

