/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.AtomicNumberProxyImpl;
import com.hazelcast.impl.CountDownLatchProxy;
import com.hazelcast.impl.CountDownLatchProxyImpl;
import com.hazelcast.impl.ExecutorServiceProxy;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.IdGeneratorProxy;
import com.hazelcast.impl.IdGeneratorProxyImpl;
import com.hazelcast.impl.ListProxy;
import com.hazelcast.impl.ListProxyImpl;
import com.hazelcast.impl.LockProxy;
import com.hazelcast.impl.LockProxyImpl;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MProxyImpl;
import com.hazelcast.impl.MultiMapProxy;
import com.hazelcast.impl.MultiMapProxyImpl;
import com.hazelcast.impl.ProxyFactory;
import com.hazelcast.impl.QProxy;
import com.hazelcast.impl.QProxyImpl;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.SemaphoreProxyImpl;
import com.hazelcast.impl.SetProxy;
import com.hazelcast.impl.SetProxyImpl;
import com.hazelcast.impl.TopicProxy;
import com.hazelcast.impl.TopicProxyImpl;
import com.hazelcast.impl.TransactionImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultProxyFactory
implements ProxyFactory {
    private final FactoryImpl factory;
    private final TransactionFactory transactionFactory = new TransactionFactory();

    public DefaultProxyFactory(FactoryImpl factory) {
        this.factory = factory;
    }

    @Override
    public MProxy createMapProxy(String name) {
        return new MProxyImpl(name, this.factory);
    }

    @Override
    public QProxy createQueueProxy(String name) {
        return new QProxyImpl(name, this.factory);
    }

    @Override
    public TopicProxy createTopicProxy(String name) {
        return new TopicProxyImpl(name, this.factory);
    }

    @Override
    public MultiMapProxy createMultiMapProxy(String name) {
        return new MultiMapProxyImpl(name, this.factory);
    }

    @Override
    public ListProxy createListProxy(String name) {
        return new ListProxyImpl(name, this.factory);
    }

    @Override
    public SetProxy createSetProxy(String name) {
        return new SetProxyImpl(name, this.factory);
    }

    @Override
    public LockProxy createLockProxy(Object key) {
        return new LockProxyImpl(this.factory, key);
    }

    @Override
    public AtomicNumberProxy createAtomicNumberProxy(String name) {
        return new AtomicNumberProxyImpl(name, this.factory);
    }

    @Override
    public SemaphoreProxy createSemaphoreProxy(String name) {
        return new SemaphoreProxyImpl(name, this.factory);
    }

    @Override
    public CountDownLatchProxy createCountDownLatchProxy(String name) {
        return new CountDownLatchProxyImpl(name, this.factory);
    }

    @Override
    public IdGeneratorProxy createIdGeneratorProxy(String name) {
        return new IdGeneratorProxyImpl(name, this.factory);
    }

    @Override
    public ExecutorService createExecutorServiceProxy(String name) {
        return new ExecutorServiceProxy(this.factory.node, name);
    }

    @Override
    public TransactionImpl createTransaction() {
        return this.transactionFactory.newTransaction();
    }

    @Override
    public void checkProxy(FactoryImpl.ProxyKey proxyKey) {
    }

    private class TransactionFactory {
        final AtomicLong ids = new AtomicLong(0L);

        private TransactionFactory() {
        }

        TransactionImpl newTransaction() {
            return new TransactionImpl(DefaultProxyFactory.this.factory, this.newTransactionId());
        }

        long newTransactionId() {
            return this.ids.incrementAndGet();
        }
    }
}

