/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.core.SemaphoreFactory;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SemaphoreConfig
implements DataSerializable {
    private String name;
    private int initialPermits;
    private boolean factoryEnabled;
    private String factoryClassName;
    private SemaphoreFactory factoryImplementation;

    public SemaphoreConfig() {
    }

    public SemaphoreConfig(String name) {
        this.name = name;
    }

    public SemaphoreConfig(String name, int initialPermits) {
        this.name = name;
        this.initialPermits = initialPermits;
    }

    public SemaphoreConfig(String name, SemaphoreConfig sc) {
        this.name = name;
        this.factoryClassName = sc.factoryClassName;
        this.initialPermits = sc.initialPermits;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.initialPermits = in.readInt();
        boolean hasFactory = in.readBoolean();
        if (hasFactory) {
            this.factoryClassName = in.readUTF();
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.initialPermits);
        boolean hasFactory = this.factoryClassName != null;
        out.writeBoolean(hasFactory);
        if (hasFactory) {
            out.writeUTF(this.factoryClassName);
        }
    }

    public String getName() {
        return this.name;
    }

    SemaphoreConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public SemaphoreConfig setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
        return this;
    }

    public boolean isFactoryEnabled() {
        return this.factoryEnabled;
    }

    public SemaphoreConfig setFactoryEnabled(boolean factoryEnabled) {
        this.factoryEnabled = factoryEnabled;
        return this;
    }

    public SemaphoreFactory getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public SemaphoreConfig setFactoryImplementation(SemaphoreFactory factoryImplementation) {
        this.factoryImplementation = factoryImplementation;
        return this;
    }

    public int getInitialPermits() {
        return this.initialPermits;
    }

    public SemaphoreConfig setInitialPermits(int initialPermits) {
        this.initialPermits = initialPermits;
        return this;
    }

    public String toString() {
        return "SemaphoreConfig [name=" + this.name + ", factoryEnabled=" + Boolean.valueOf(this.factoryEnabled) + ", factoryClassName=" + this.factoryClassName + ", factoryImplementation=" + this.factoryImplementation + "]";
    }
}

