/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.javaee;

import javax.servlet.http.HttpServletRequest;
import org.javasimon.Manager;
import org.javasimon.Stopwatch;
import org.javasimon.javaee.SimonServletFilterUtils;
import org.javasimon.source.AbstractStopwatchSource;
import org.javasimon.source.CacheMonitorSource;
import org.javasimon.source.MonitorSource;
import org.javasimon.utils.Replacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStopwatchSource
extends AbstractStopwatchSource<HttpServletRequest> {
    public static final String DEFAULT_SIMON_PREFIX = "org.javasimon.web";
    private String prefix = "org.javasimon.web";
    private Replacer unallowedCharacterReplacer = SimonServletFilterUtils.createUnallowedCharsReplacer("_");
    private Replacer jsessionParameterReplacer = new Replacer("[;&]?JSESSIONID=[^;?/&]*", "", new Replacer.Modificator[]{Replacer.Modificator.IGNORE_CASE});

    public HttpStopwatchSource(Manager manager) {
        super(manager);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getReplaceUnallowed() {
        return this.unallowedCharacterReplacer.getTo();
    }

    public void setReplaceUnallowed(String replaceUnallowed) {
        this.unallowedCharacterReplacer.setTo(replaceUnallowed);
    }

    protected final String getMonitorName(HttpServletRequest request) {
        String uri = this.requestToStringForMonitorName(request);
        String localName = SimonServletFilterUtils.getSimonName(uri, this.unallowedCharacterReplacer);
        if (this.prefix == null || this.prefix.isEmpty()) {
            return localName;
        }
        return this.prefix + "." + localName;
    }

    protected String requestToStringForMonitorName(HttpServletRequest request) {
        String uri = request.getRequestURI();
        uri = this.removeJSessionIdFromUri(uri);
        return uri;
    }

    protected String removeJSessionIdFromUri(String uri) {
        return this.jsessionParameterReplacer.process(uri);
    }

    public boolean isMonitored(HttpServletRequest httpServletRequest) {
        String uri = httpServletRequest.getRequestURI().toLowerCase();
        return !uri.endsWith(".css") && !uri.endsWith(".png") && !uri.endsWith(".gif") && !uri.endsWith(".jpg") && !uri.endsWith(".js");
    }

    public Stopwatch getMonitor(HttpServletRequest request) {
        Stopwatch stopwatch = super.getMonitor((Object)request);
        if (stopwatch.getNote() == null) {
            stopwatch.setNote(request.getRequestURI());
        }
        return stopwatch;
    }

    public static MonitorSource<HttpServletRequest, Stopwatch> newCacheStopwatchSource(MonitorSource<HttpServletRequest, Stopwatch> stopwatchSource) {
        return new CacheMonitorSource<HttpServletRequest, Stopwatch, String>(stopwatchSource){

            protected String getLocationKey(HttpServletRequest l) {
                return l.getRequestURI();
            }
        };
    }
}

