/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SheetTableModel;
import org.jopendocument.dom.spreadsheet.Table;

public class SpreadSheet
implements ODDocument {
    private final ODPackage originalFile;
    private final Map<Element, Sheet> sheets;
    private static final String minCell = "\\$?([A-Z]+)\\$?([0-9]+)";
    static final Pattern cellPattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?([A-Z]+)\\$?([0-9]+))");
    static final Pattern minCellPattern = Pattern.compile("\\$?([A-Z]+)\\$?([0-9]+)");
    private static final Pattern cellRangePattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+)(:(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+))?");

    public static SpreadSheet createFromFile(File file) throws IOException {
        return SpreadSheet.create(new ODPackage(file));
    }

    public static SpreadSheet create(ODPackage oDPackage) {
        return new SpreadSheet(oDPackage.getDocument("content.xml"), oDPackage.getDocument("styles.xml"), oDPackage);
    }

    public static SpreadSheet createEmpty(TableModel tableModel) throws IOException {
        return SpreadSheet.createEmpty(tableModel, XMLVersion.getOD());
    }

    public static SpreadSheet createEmpty(TableModel tableModel, XMLVersion xMLVersion) throws IOException {
        Element element;
        ContentTypeVersioned contentTypeVersioned;
        Document document = new Document(new Element("document", xMLVersion.getOFFICE()));
        if (xMLVersion == XMLVersion.OOo) {
            document.setDocType(new DocType("office:document", "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", "office.dtd"));
        }
        if ((contentTypeVersioned = ContentTypeVersioned.fromType(ContentType.SPREADSHEET, xMLVersion)).getVersion().equals((Object)XMLVersion.OOo)) {
            document.getRootElement().setAttribute("class", contentTypeVersioned.getShortName(), xMLVersion.getOFFICE());
        } else if (contentTypeVersioned.getVersion().equals((Object)XMLVersion.OD)) {
            document.getRootElement().setAttribute("mimetype", contentTypeVersioned.getMimeType(), xMLVersion.getOFFICE());
        }
        document.getRootElement().addContent(new Element("automatic-styles", xMLVersion.getOFFICE()));
        Element element2 = new Element("body", xMLVersion.getOFFICE());
        if (contentTypeVersioned.getVersion().equals((Object)XMLVersion.OD)) {
            element = new Element(contentTypeVersioned.getShortName(), xMLVersion.getOFFICE());
            element2.addContent(element);
        } else {
            element = element2;
        }
        document.getRootElement().addContent(element2);
        Element element3 = Sheet.createEmpty(xMLVersion);
        element.addContent(element3);
        SpreadSheet spreadSheet = new SpreadSheet(document, null);
        spreadSheet.getSheet(0).merge(tableModel, 0, 0, true);
        return spreadSheet;
    }

    public static File export(TableModel tableModel, File file, XMLVersion xMLVersion) throws IOException {
        return SpreadSheet.createEmpty(tableModel, xMLVersion).saveAs(file);
    }

    public SpreadSheet(Document document, Document document2) {
        this(document, document2, null);
    }

    private SpreadSheet(Document document, Document document2, ODPackage oDPackage) {
        this.originalFile = oDPackage != null ? oDPackage : new ODPackage();
        this.originalFile.putFile("content.xml", document);
        if (document2 != null) {
            this.originalFile.putFile("styles.xml", document2);
        }
        this.sheets = new HashMap<Element, Sheet>();
    }

    final Document getContent() {
        return this.getPackage().getContent().getDocument();
    }

    @Override
    public final XMLVersion getVersion() {
        return this.getPackage().getVersion();
    }

    private Element getBody() {
        Element element = this.getContent().getRootElement().getChild("body", this.getVersion().getOFFICE());
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            return element;
        }
        return element.getChild("spreadsheet", this.getVersion().getOFFICE());
    }

    protected final String parseSheetName(String string) {
        if (string == null) {
            return null;
        }
        return string.charAt(0) == '$' ? string.substring(1) : string;
    }

    public final SheetTableModel.MutableTableModel<SpreadSheet> getTableModel(String string) {
        Element element;
        Object object;
        try {
            object = this.getXPath("./table:named-expressions/table:named-range[@table:name='" + string + "']");
            element = (Element)((XPath)object).selectSingleNode(this.getBody());
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException(jDOMException);
        }
        if (element == null) {
            return null;
        }
        object = element.getAttributeValue("cell-range-address", this.getVersion().getTABLE());
        Matcher matcher = cellRangePattern.matcher((CharSequence)object);
        if (!matcher.matches()) {
            throw new IllegalStateException((String)object + " is not a valid range address");
        }
        String string2 = this.parseSheetName(matcher.group(1));
        String string3 = this.parseSheetName(matcher.group(6));
        if (string3 != null && !string3.equals(string2)) {
            throw new UnsupportedOperationException("different sheet names: " + string2 + " != " + string3);
        }
        Sheet sheet = this.getSheet(string2, true);
        Point point = Table.resolve(matcher.group(4));
        Point point2 = Table.resolve(matcher.group(9));
        return sheet.getMutableTableModel(point, point2);
    }

    public final Cell<SpreadSheet> getCellAt(String string) {
        Matcher matcher = cellPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string + " is not a valid cell address: " + matcher.pattern().pattern());
        }
        String string2 = this.parseSheetName(matcher.group(1));
        if (string2 == null) {
            throw new IllegalArgumentException("no sheet specified: " + string);
        }
        return this.getSheet(string2, true).getCellAt(Sheet.resolve(matcher.group(5), matcher.group(6)));
    }

    public XPath getXPath(String string) throws JDOMException {
        return OOUtils.getXPath(string, this.getVersion());
    }

    private final List<Element> getTables() {
        return this.getBody().getChildren("table", this.getVersion().getTABLE());
    }

    public int getSheetCount() {
        return this.getTables().size();
    }

    public Sheet getSheet(int n) {
        return this.getSheet(this.getTables().get(n));
    }

    public Sheet getSheet(String string) {
        return this.getSheet(string, false);
    }

    public Sheet getSheet(String string, boolean bl) throws NoSuchElementException {
        for (Element element : this.getTables()) {
            if (!string.equals(Table.getName(element))) continue;
            return this.getSheet(element);
        }
        if (bl) {
            throw new NoSuchElementException("no such sheet: " + string);
        }
        return null;
    }

    private final Sheet getSheet(Element element) {
        Sheet sheet = this.sheets.get(element);
        if (sheet == null) {
            sheet = new Sheet(this, element);
            this.sheets.put(element, sheet);
        }
        return sheet;
    }

    void invalidate(Element element) {
        this.sheets.remove(element);
    }

    public final Sheet addSheet(int n, String string) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        Element element = Table.createEmpty(this.getVersion());
        return this.addSheet(n, element, string);
    }

    final Sheet addSheet(int n, Element element, String string) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n);
        }
        if (n > this.getSheetCount()) {
            throw new IndexOutOfBoundsException("index (" + n + ") > count (" + this.getSheetCount() + ")");
        }
        Element element2 = this.getSheet(0).getElement();
        int n2 = element2.getParentElement().indexOf(element2);
        element2.getParentElement().addContent(n2 + n, element);
        Sheet sheet = this.getSheet(element);
        if (string != null) {
            sheet.setName(string);
        }
        assert (sheet.getName() != null);
        return sheet;
    }

    public final Sheet addSheet(String string) {
        return this.addSheet(this.getSheetCount(), string);
    }

    void move(Sheet sheet, int n) {
        Element element = sheet.getElement().getParentElement();
        sheet.getElement().detach();
        element.addContent(n, sheet.getElement());
    }

    public File saveAs(File file) throws FileNotFoundException, IOException {
        this.getPackage().setFile(file);
        return this.getPackage().save();
    }

    @Override
    public final ODPackage getPackage() {
        return this.originalFile;
    }
}

