/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.GraphicStyle;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.TableStyle;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.util.JDOMUtils;

public class StyleStyle
extends ODNode {
    private static final Map<XMLVersion, Map<String, StyleDesc<?>>> family2Desc;
    private static final Map<XMLVersion, Map<Class<? extends StyleStyle>, StyleDesc<?>>> class2Desc;
    private static boolean descsLoaded;
    private final StyleDesc<?> desc;
    private final ODPackage pkg;
    private final String name;
    private final String family;
    private final XMLVersion ns;

    private static void loadDescs() {
        if (!descsLoaded) {
            StyleStyle.registerAllVersions(CellStyle.DESC);
            StyleStyle.registerAllVersions(RowStyle.DESC);
            StyleStyle.registerAllVersions(ColumnStyle.DESC);
            StyleStyle.registerAllVersions(TableStyle.DESC);
            StyleStyle.registerAllVersions(ParagraphStyle.DESC);
            StyleStyle.registerAllVersions(GraphicStyle.DESC);
            descsLoaded = true;
        }
    }

    private static void registerAllVersions(StyleDesc<? extends StyleStyle> styleDesc) {
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            if (xMLVersion == styleDesc.getVersion()) {
                StyleStyle.register(styleDesc);
                continue;
            }
            StyleStyle.register(StyleDesc.copy(styleDesc, xMLVersion));
        }
    }

    public static void register(StyleDesc<? extends StyleStyle> styleDesc) {
        if (family2Desc.get((Object)styleDesc.getVersion()).put(styleDesc.getFamily(), styleDesc) != null) {
            throw new IllegalStateException(styleDesc.getFamily() + " duplicate");
        }
        if (class2Desc.get((Object)styleDesc.getVersion()).put(styleDesc.getStyleClass(), styleDesc) != null) {
            throw new IllegalStateException(styleDesc.getStyleClass() + " duplicate");
        }
    }

    public static StyleStyle warp(ODPackage oDPackage, Element element) {
        StyleStyle styleStyle = new StyleStyle(oDPackage, element);
        StyleStyle.loadDescs();
        Map<String, StyleDesc<?>> map = family2Desc.get((Object)oDPackage.getVersion());
        if (map.containsKey(styleStyle.getFamily())) {
            StyleDesc<?> styleDesc = map.get(styleStyle.getFamily());
            return styleDesc.create(oDPackage, element);
        }
        return styleStyle;
    }

    static <S extends StyleStyle> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion xMLVersion) {
        return StyleStyle.getStyleDesc(clazz, xMLVersion, true);
    }

    private static <S extends StyleStyle> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion xMLVersion, boolean bl) {
        StyleStyle.loadDescs();
        Map<Class<StyleStyle>, StyleDesc<?>> map = class2Desc.get((Object)xMLVersion);
        if (map.containsKey(clazz)) {
            return map.get(clazz);
        }
        if (bl) {
            throw new IllegalArgumentException("unregistered " + clazz + " for version " + (Object)((Object)xMLVersion));
        }
        return null;
    }

    public StyleStyle(ODPackage oDPackage, Element element) {
        super(element);
        this.pkg = oDPackage;
        this.name = this.getElement().getAttributeValue("name", this.getSTYLE());
        this.family = this.getElement().getAttributeValue("family", this.getSTYLE());
        this.ns = this.pkg.getVersion();
        this.desc = StyleStyle.getStyleDesc(this.getClass(), this.ns, false);
        if (this.desc != null && !this.desc.getFamily().equals(this.getFamily())) {
            throw new IllegalArgumentException("expected " + this.desc.getFamily() + " but got " + this.getFamily() + " for " + element);
        }
        assert (this.pkg.getXMLFile(this.getElement().getDocument()) != null);
        assert (this.pkg.getVersion() == XMLVersion.getVersion(this.getElement()));
    }

    protected final Namespace getSTYLE() {
        return this.getElement().getNamespace("style");
    }

    public final XMLVersion getNS() {
        return this.ns;
    }

    public final String getName() {
        return this.name;
    }

    public final String getFamily() {
        return this.family;
    }

    public final Element getFormattingProperties() {
        return this.getFormattingProperties(this.getFamily());
    }

    public final Element getFormattingProperties(String string) {
        String string2 = this.getNS() == XMLVersion.OD ? string + "-properties" : "properties";
        Element element = this.getElement().getChild(string2, this.getSTYLE());
        if (element == null) {
            element = new Element(string2, this.getSTYLE());
            this.getElement().addContent(element);
        }
        return element;
    }

    private final List<Element> getReferences(Document document, boolean bl, boolean bl2) {
        return this.desc.getReferences(document, this.getName(), bl, bl2);
    }

    public final List<Element> getReferences() {
        return this.getReferences(true, true);
    }

    private final List<Element> getReferences(boolean bl, boolean bl2) {
        Document document = this.getElement().getDocument();
        Document document2 = this.pkg.getContent().getDocument();
        List<Element> list = this.getReferences(document, bl, bl2);
        if (document != document2 && !this.isAutomatic()) {
            list.addAll(this.getReferences(document2, bl, bl2));
        }
        return list;
    }

    private final boolean isAutomatic() {
        return this.getElement().getParentElement().getQualifiedName().equals("office:automatic-styles");
    }

    public final boolean isReferencedAtMostOnce() {
        return this.getReferences(false, true).size() == 0 && this.getReferences(true, false).size() <= 1;
    }

    public final StyleStyle dup() {
        ODXMLDocument oDXMLDocument = this.pkg.getXMLFile(this.getElement().getDocument());
        String string = oDXMLDocument.findUnusedName(this.getFamily(), this.desc == null ? this.getName() : this.desc.getBaseName());
        Element element = (Element)this.getElement().clone();
        element.setAttribute("name", string, this.getSTYLE());
        JDOMUtils.insertAfter(this.getElement(), Collections.singleton(element));
        return this.desc == null ? new StyleStyle(this.pkg, element) : this.desc.create(this.pkg, element);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof StyleStyle)) {
            return false;
        }
        StyleStyle styleStyle = (StyleStyle)object;
        return this.getName().equals(styleStyle.getName()) && this.getFamily().equals(styleStyle.getFamily());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getFamily().hashCode();
    }

    static {
        descsLoaded = false;
        family2Desc = new HashMap();
        class2Desc = new HashMap();
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            family2Desc.put(xMLVersion, new HashMap());
            class2Desc.put(xMLVersion, new HashMap());
        }
    }
}

