/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;

public class MetadataBlockDataStreamInfo
implements MetadataBlockData {
    public static final int STREAM_INFO_DATA_LENGTH = 34;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac.MetadataBlockDataStreamInfo");
    private int minBlockSize;
    private int maxBlockSize;
    private int minFrameSize;
    private int maxFrameSize;
    private int samplingRate;
    private int samplingRatePerChannel;
    private int bitsPerSample;
    private int channelNumber;
    private int totalNumberOfSamples;
    private float songLength;
    private String md5;
    private boolean isValid = true;
    private ByteBuffer rawdata;

    public MetadataBlockDataStreamInfo(MetadataBlockHeader header, RandomAccessFile raf) throws IOException {
        this.rawdata = ByteBuffer.allocate(header.getDataLength());
        int bytesRead = raf.getChannel().read(this.rawdata);
        if (bytesRead < header.getDataLength()) {
            throw new IOException("Unable to read required number of databytes read:" + bytesRead + ":required:" + header.getDataLength());
        }
        this.rawdata.rewind();
        this.minBlockSize = this.rawdata.getShort();
        this.maxBlockSize = this.rawdata.getShort();
        this.minFrameSize = this.readThreeByteInteger(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.maxFrameSize = this.readThreeByteInteger(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.samplingRate = this.readSamplingRate(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.channelNumber = ((this.u(this.rawdata.get(12)) & 0xE) >>> 1) + 1;
        this.samplingRatePerChannel = this.samplingRate / this.channelNumber;
        this.bitsPerSample = ((this.u(this.rawdata.get(12)) & 1) << 4) + ((this.u(this.rawdata.get(13)) & 0xF0) >>> 4) + 1;
        this.totalNumberOfSamples = this.readTotalNumberOfSamples(this.rawdata.get(13), this.rawdata.get(14), this.rawdata.get(15), this.rawdata.get(16), this.rawdata.get(17));
        StringBuilder sb = new StringBuilder();
        for (int i = 18; i < 34; ++i) {
            byte dataByte = this.rawdata.get(i);
            sb.append(String.format("%x", dataByte));
        }
        this.md5 = sb.toString();
        this.songLength = (float)((double)this.totalNumberOfSamples / (double)this.samplingRate);
        logger.config(this.toString());
    }

    public byte[] getBytes() {
        return this.rawdata.array();
    }

    public int getLength() {
        return this.getBytes().length;
    }

    public String toString() {
        return "MinBlockSize:" + this.minBlockSize + "MaxBlockSize:" + this.maxBlockSize + "MinFrameSize:" + this.minFrameSize + "MaxFrameSize:" + this.maxFrameSize + "SampleRateTotal:" + this.samplingRate + "SampleRatePerChannel:" + this.samplingRatePerChannel + ":Channel number:" + this.channelNumber + ":Bits per sample: " + this.bitsPerSample + ":TotalNumberOfSamples: " + this.totalNumberOfSamples + ":Length: " + this.songLength;
    }

    public int getSongLength() {
        return (int)this.songLength;
    }

    public float getPreciseLength() {
        return this.songLength;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getSamplingRatePerChannel() {
        return this.samplingRatePerChannel;
    }

    public String getEncodingType() {
        return "FLAC " + this.bitsPerSample + " bits";
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public String getMD5Signature() {
        return this.md5;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private int readThreeByteInteger(byte b1, byte b2, byte b3) {
        int rate = (this.u(b1) << 16) + (this.u(b2) << 8) + this.u(b3);
        return rate;
    }

    private int readSamplingRate(byte b1, byte b2, byte b3) {
        int rate = (this.u(b1) << 12) + (this.u(b2) << 4) + ((this.u(b3) & 0xF0) >>> 4);
        return rate;
    }

    private int readTotalNumberOfSamples(byte b1, byte b2, byte b3, byte b4, byte b5) {
        int nb = this.u(b5);
        nb += this.u(b4) << 8;
        nb += this.u(b3) << 16;
        nb += this.u(b2) << 24;
        return nb += (this.u(b1) & 0xF) << 32;
    }

    private int u(int i) {
        return i & 0xFF;
    }
}

