/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jaudiotagger.audio.aiff.AiffUtil;

public class ChunkHeader {
    private long _size;
    private String _chunkID;

    public boolean readHeader(RandomAccessFile raf) throws IOException {
        StringBuffer id = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int ch = raf.read();
            if (ch < 32) {
                String hx = Integer.toHexString(ch);
                if (hx.length() < 2) {
                    hx = "0" + hx;
                }
                return false;
            }
            id.append((char)ch);
        }
        this._chunkID = id.toString();
        this._size = AiffUtil.readUINT32(raf);
        return true;
    }

    public void setID(String id) {
        this._chunkID = id;
    }

    public String getID() {
        return this._chunkID;
    }

    public long getSize() {
        return this._size;
    }
}

