/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.parser.chm.accessor.ChmDirectoryListingSet;
import org.apache.tika.parser.chm.accessor.ChmItsfHeader;
import org.apache.tika.parser.chm.accessor.ChmItspHeader;
import org.apache.tika.parser.chm.accessor.ChmLzxcControlData;
import org.apache.tika.parser.chm.accessor.ChmLzxcResetTable;
import org.apache.tika.parser.chm.accessor.DirectoryListingEntry;
import org.apache.tika.parser.chm.assertion.ChmAssert;
import org.apache.tika.parser.chm.core.ChmCommons;
import org.apache.tika.parser.chm.lzx.ChmBlockInfo;
import org.apache.tika.parser.chm.lzx.ChmLzxBlock;

public class ChmExtractor {
    private List<ChmLzxBlock> lzxBlocksCache = null;
    private ChmDirectoryListingSet chmDirList = null;
    private ChmItsfHeader chmItsfHeader = null;
    private ChmItspHeader chmItspHeader = null;
    private ChmLzxcResetTable chmLzxcResetTable = null;
    private ChmLzxcControlData chmLzxcControlData = null;
    private byte[] data = null;
    private int indexOfContent;
    private long lzxBlockOffset;
    private long lzxBlockLength;

    private ChmLzxcControlData getChmLzxcControlData() {
        return this.chmLzxcControlData;
    }

    private void setChmLzxcControlData(ChmLzxcControlData chmLzxcControlData) {
        this.chmLzxcControlData = chmLzxcControlData;
    }

    private ChmItspHeader getChmItspHeader() {
        return this.chmItspHeader;
    }

    private void setChmItspHeader(ChmItspHeader chmItspHeader) {
        this.chmItspHeader = chmItspHeader;
    }

    private ChmLzxcResetTable getChmLzxcResetTable() {
        return this.chmLzxcResetTable;
    }

    private void setChmLzxcResetTable(ChmLzxcResetTable chmLzxcResetTable) {
        this.chmLzxcResetTable = chmLzxcResetTable;
    }

    private long getLzxBlockLength() {
        return this.lzxBlockLength;
    }

    private void setLzxBlockLength(long lzxBlockLength) {
        this.lzxBlockLength = lzxBlockLength;
    }

    private long getLzxBlockOffset() {
        return this.lzxBlockOffset;
    }

    private void setLzxBlockOffset(long lzxBlockOffset) {
        this.lzxBlockOffset = lzxBlockOffset;
    }

    private int getIndexOfContent() {
        return this.indexOfContent;
    }

    private void setIndexOfContent(int indexOfContent) {
        this.indexOfContent = indexOfContent;
    }

    private byte[] getData() {
        return this.data;
    }

    private void setData(byte[] data) {
        this.data = data;
    }

    public ChmExtractor(InputStream is) throws TikaException, IOException {
        ChmAssert.assertInputStreamNotNull(is);
        try {
            this.setData(IOUtils.toByteArray(is));
            this.setChmItsfHeader(new ChmItsfHeader());
            this.getChmItsfHeader().parse(ChmCommons.copyOfRange(this.getData(), 0, 95), this.getChmItsfHeader());
            this.setChmItspHeader(new ChmItspHeader());
            this.getChmItspHeader().parse(ChmCommons.copyOfRange(this.getData(), (int)this.getChmItsfHeader().getDirOffset(), (int)this.getChmItsfHeader().getDirOffset() + 84), this.getChmItspHeader());
            this.setChmDirList(new ChmDirectoryListingSet(this.getData(), this.getChmItsfHeader(), this.getChmItspHeader()));
            int indexOfControlData = this.getChmDirList().getControlDataIndex();
            int indexOfResetData = ChmCommons.indexOfResetTableBlock(this.getData(), "LZXC".getBytes());
            byte[] dir_chunk = null;
            if (indexOfResetData > 0) {
                dir_chunk = ChmCommons.copyOfRange(this.getData(), indexOfResetData, indexOfResetData + this.getChmDirList().getDirectoryListingEntryList().get(indexOfControlData).getLength());
            }
            this.setChmLzxcControlData(new ChmLzxcControlData());
            this.getChmLzxcControlData().parse(dir_chunk, this.getChmLzxcControlData());
            int indexOfResetTable = this.getChmDirList().getResetTableIndex();
            this.setChmLzxcResetTable(new ChmLzxcResetTable());
            int startIndex = (int)this.getChmDirList().getDataOffset() + this.getChmDirList().getDirectoryListingEntryList().get(indexOfResetTable).getOffset();
            ChmAssert.assertCopyingDataIndex(startIndex, this.getData().length);
            dir_chunk = ChmCommons.copyOfRange(this.getData(), startIndex, startIndex + this.getChmDirList().getDirectoryListingEntryList().get(indexOfResetTable).getLength());
            this.getChmLzxcResetTable().parse(dir_chunk, this.getChmLzxcResetTable());
            this.setIndexOfContent(ChmCommons.indexOf(this.getChmDirList().getDirectoryListingEntryList(), "Content"));
            this.setLzxBlockOffset((long)this.getChmDirList().getDirectoryListingEntryList().get(this.getIndexOfContent()).getOffset() + this.getChmItsfHeader().getDataOffset());
            this.setLzxBlockLength(this.getChmDirList().getDirectoryListingEntryList().get(this.getIndexOfContent()).getLength());
            this.setLzxBlocksCache(new ArrayList<ChmLzxBlock>());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> enumerateChm() {
        ArrayList<String> listOfEntries = new ArrayList<String>();
        Iterator<DirectoryListingEntry> it = this.getChmDirList().getDirectoryListingEntryList().iterator();
        while (it.hasNext()) {
            listOfEntries.add(it.next().getName());
        }
        return listOfEntries;
    }

    public byte[][] extractChmEntry(DirectoryListingEntry directoryListingEntry) throws TikaException {
        Object tmp = null;
        byte[] dataSegment = null;
        ChmLzxBlock lzxBlock = null;
        try {
            if (directoryListingEntry.getEntryType() == ChmCommons.EntryType.UNCOMPRESSED && directoryListingEntry.getLength() > 0 && !ChmCommons.hasSkip(directoryListingEntry)) {
                int dataOffset = (int)(this.getChmItsfHeader().getDataOffset() + (long)directoryListingEntry.getOffset());
                dataSegment = ChmCommons.copyOfRange(this.getData(), dataOffset, dataOffset + directoryListingEntry.getLength());
            } else if (directoryListingEntry.getEntryType() == ChmCommons.EntryType.COMPRESSED && !ChmCommons.hasSkip(directoryListingEntry)) {
                ChmBlockInfo bb = ChmBlockInfo.getChmBlockInfoInstance(directoryListingEntry, (int)this.getChmLzxcResetTable().getBlockLen(), this.getChmLzxcControlData());
                tmp = new byte[bb.getEndBlock() - bb.getStartBlock() + 1][];
                int i = 0;
                int start = 0;
                int block = 0;
                if (this.getLzxBlockLength() < Integer.MAX_VALUE && this.getLzxBlockOffset() < Integer.MAX_VALUE) {
                    if (this.getLzxBlocksCache().size() != 0) {
                        block2: for (i = 0; i < this.getLzxBlocksCache().size(); ++i) {
                            lzxBlock = this.getLzxBlocksCache().get(i);
                            for (int j = bb.getIniBlock(); j <= bb.getStartBlock(); ++j) {
                                if (lzxBlock.getBlockNumber() == j && j > start) {
                                    start = j;
                                    block = i;
                                }
                                if (start == bb.getStartBlock()) continue block2;
                            }
                        }
                    }
                    if (i == this.getLzxBlocksCache().size() && i == 0) {
                        start = bb.getIniBlock();
                        dataSegment = ChmCommons.getChmBlockSegment(this.getData(), this.getChmLzxcResetTable(), start, (int)this.getLzxBlockOffset(), (int)this.getLzxBlockLength());
                        lzxBlock = new ChmLzxBlock(start, dataSegment, this.getChmLzxcResetTable().getBlockLen(), null);
                        this.getLzxBlocksCache().add(lzxBlock);
                    } else {
                        lzxBlock = this.getLzxBlocksCache().get(block);
                    }
                    i = start;
                    while (i <= bb.getEndBlock()) {
                        if (i == bb.getStartBlock() && i == bb.getEndBlock()) {
                            dataSegment = lzxBlock.getContent(bb.getStartOffset(), bb.getEndOffset());
                            tmp[0] = dataSegment;
                            break;
                        }
                        if (i == bb.getStartBlock()) {
                            dataSegment = lzxBlock.getContent(bb.getStartOffset());
                            tmp[0] = dataSegment;
                        }
                        if (i > bb.getStartBlock() && i < bb.getEndBlock()) {
                            dataSegment = lzxBlock.getContent();
                            tmp[i - bb.getStartBlock()] = dataSegment;
                        }
                        if (i == bb.getEndBlock()) {
                            dataSegment = lzxBlock.getContent(0, bb.getEndOffset());
                            tmp[i - bb.getStartBlock()] = dataSegment;
                            break;
                        }
                        lzxBlock = (long)(++i) % this.getChmLzxcControlData().getResetInterval() == 0L ? new ChmLzxBlock(i, ChmCommons.getChmBlockSegment(this.getData(), this.getChmLzxcResetTable(), i, (int)this.getLzxBlockOffset(), (int)this.getLzxBlockLength()), this.getChmLzxcResetTable().getBlockLen(), null) : new ChmLzxBlock(i, ChmCommons.getChmBlockSegment(this.getData(), this.getChmLzxcResetTable(), i, (int)this.getLzxBlockOffset(), (int)this.getLzxBlockLength()), this.getChmLzxcResetTable().getBlockLen(), lzxBlock);
                        this.getLzxBlocksCache().add(lzxBlock);
                    }
                    if ((long)this.getLzxBlocksCache().size() > this.getChmLzxcResetTable().getBlockCount()) {
                        this.getLzxBlocksCache().clear();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TikaException(e.getMessage());
        }
        return (byte[][])(tmp != null ? tmp : (byte[][])new byte[1][]);
    }

    private void setLzxBlocksCache(List<ChmLzxBlock> lzxBlocksCache) {
        this.lzxBlocksCache = lzxBlocksCache;
    }

    private List<ChmLzxBlock> getLzxBlocksCache() {
        return this.lzxBlocksCache;
    }

    private void setChmDirList(ChmDirectoryListingSet chmDirList) {
        this.chmDirList = chmDirList;
    }

    public ChmDirectoryListingSet getChmDirList() {
        return this.chmDirList;
    }

    private void setChmItsfHeader(ChmItsfHeader chmItsfHeader) {
        this.chmItsfHeader = chmItsfHeader;
    }

    private ChmItsfHeader getChmItsfHeader() {
        return this.chmItsfHeader;
    }
}

