/*
 * Decompiled with CFR 0.152.
 */
package org.json.helpers;

import java.io.Writer;
import org.json.helpers.StringAllocator;

public class UnsynchronizedStringWriter
extends Writer {
    private final StringAllocator buf;

    public UnsynchronizedStringWriter() {
        this.buf = new StringAllocator();
        this.lock = this.buf;
    }

    public UnsynchronizedStringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buf = new StringAllocator(initialSize);
        this.lock = this.buf;
    }

    public UnsynchronizedStringWriter(StringAllocator buf) {
        if (buf == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        this.buf = buf;
        this.lock = this.buf;
    }

    public void write(int c) {
        this.buf.append((char)c);
    }

    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.append(cbuf, off, len);
    }

    public void write(String str) {
        this.buf.append(str);
    }

    public void write(String str, int off, int len) {
        this.buf.append(str.substring(off, off + len));
    }

    public UnsynchronizedStringWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    public UnsynchronizedStringWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    public UnsynchronizedStringWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buf.toString();
    }

    public StringAllocator getAllocator() {
        return this.buf;
    }

    public void flush() {
    }

    public void close() {
    }
}

