#! /bin/bash

LFILES=( $(find . -type f -name "*de_DE.po") )
NLFILES=( $(for l in ${LFILES[*]}; do echo ${l//DE/CH}; done) )
echo -e "do you want to generate the following files?\n"
NR=$(( ${#LFILES[*]} - 1 ))
for i in $(seq 0 $NR ); do
    echo -e "\t${LFILES[$i]} -> ${NLFILES[$i]}"
done
echo
read -p "enter y or n (n is default): " A
if [ "$A" != "y" ]; then
   echo "exiting"
   exit
fi
for i in $(seq 0 $NR ); do
    ilang=${LFILES[$i]}
    olang=${NLFILES[$i]}
    if [ ! -e $ilang ]; then
	echo "unable to open $ilang"
	exit 1
    fi
    perl -e '
use strict;

while( my $line=<STDIN> ) {
   print $line;
   if( $line =~ /^msgstr/ ) {
      do {
         $line = <STDIN>;
         chomp($line);
         $line =~ s/ß/ss/g;
         $line =~ s/Bundesland/Kanton/g;
         $line =~ s/Serien-Dauer/Seriendauer/g;
         $line =~ s/Mime-Typ/Datei-Typ/g;
         $line =~ s/Popups/Pop-ups/g;
         $line =~ s/[sS]ession([-])/Sitzungs$1/g;
         $line =~ s/[sS]ession([ .])/Sitzung$1/g;
         print "$line\n";
      } while( length($line) );
   }
}
' < $ilang > $olang
done
