/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.rest.services.users.mailmapping;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.util.NativeBuilders.MapBuilder;
import com.openexchange.mailmapping.MailResolver;
import com.openexchange.mailmapping.ResolvedMail;
import com.openexchange.rest.services.OXRESTService;
import com.openexchange.rest.services.annotations.GET;
import com.openexchange.rest.services.annotations.ROOT;
import com.openexchange.user.UserService;
import static com.openexchange.java.util.NativeBuilders.*;

/**
 * {@link MailMappingService}
 *
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
@ROOT("/utilities/mailResolver/v1")
public class MailMappingService extends OXRESTService<MailResolver> {
    
    /**
     * GET /rest/utilities/mailResolver/resolve/[mail1];[mail2]
     * 
     * Tries to resolve the given mail addresses to context and user IDs.
     * Returns an Object with the mail addresses as keys and objects with the keys "user" (for the userId) and "context" (for the contextId) as values.
     * If a mail address is unknown, the corresponding key will be missing in the response.
     */
    @GET("/resolve/:mail")
    public Object resolve(String mail) throws OXException {
        String[] mails = mail.split(";");
        MapBuilder<Object, Object> result = map();

        for (String m : mails) {
            ResolvedMail resolved = context.resolve(m);
            if (resolved == null) {
                continue;
            }
            ContextService contexts = services.getService(ContextService.class);
            Context ctx = contexts.getContext(resolved.getContextID());
            User user = services.getService(UserService.class).getUser(resolved.getUserID(), ctx);
            
            result.put(
                m,
                map()
                    .put("uid", resolved.getUserID())
                    .put("cid", resolved.getContextID())
                    .put("user", map()
                        .put("language", user.getPreferredLanguage())
                        .put("displayName", user.getDisplayName())
                        .build())
                    .build()
            );
        }
        
        return result.build();
    }
}
