/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.solrext.tokenfilter;

import com.openexchange.mail.mime.QuotedInternetAddress;
import java.io.IOException;
import javax.mail.internet.AddressException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class InternetAddressCleanupFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private static final Log log = LogFactory.getLog(InternetAddressCleanupFilter.class);

    public InternetAddressCleanupFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            try {
                String attr = this.termAttribute.toString();
                log.debug((Object)("[incrementToken]: Starting with '" + attr + "'"));
                try {
                    QuotedInternetAddress internetAddr = new QuotedInternetAddress(attr);
                    log.debug((Object)("[incrementToken]: Input is '" + attr + "'"));
                    this.termAttribute.setEmpty();
                    if (internetAddr.getPersonal() != null) {
                        this.termAttribute.append(internetAddr.getPersonal());
                    }
                    if (internetAddr.getIDNAddress() != null) {
                        this.termAttribute.append(" ");
                        this.termAttribute.append(internetAddr.getAddress());
                    }
                    log.debug((Object)("[incrementToken]: Modified is '" + attr + "'"));
                }
                catch (AddressException e) {
                    this.termAttribute.setEmpty();
                    this.termAttribute.append(attr);
                    log.error((Object)("[incrementToken]: AddressException, using original term: '" + attr + "'"));
                }
                return true;
            }
            catch (Throwable e) {
                log.error((Object)("[incrementToken]: " + e.getMessage()));
                throw new IOException(e);
            }
        }
        return false;
    }
}

