/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.LogUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    int maxNumToLog = 8;

    public void init(NamedList args) {
        if (args != null) {
            SolrParams params = SolrParams.toSolrParams((NamedList)args);
            this.maxNumToLog = params.getInt("maxNumToLog", this.maxNumToLog);
        }
    }

    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        Logger logger = LoggerFactory.getLogger(LogUpdateProcessor.class);
        boolean doLog = logger.isInfoEnabled();
        if (doLog) {
            LogUpdateProcessor processor = new LogUpdateProcessor(req, rsp, this, next);
            assert (processor.log == logger);
            return processor;
        }
        return null;
    }
}

