/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.SolrSortField;
import org.apache.solr.search.function.DocValues;

public abstract class ValueSource
implements Serializable {
    private static FieldComparatorSource dummyComparator = new FieldComparatorSource(){

        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unweighted use of sort " + fieldname);
        }
    };

    @Deprecated
    public DocValues getValues(IndexReader reader) throws IOException {
        return this.getValues(null, reader);
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return this.getValues(reader);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public String toString() {
        return this.description();
    }

    public void createWeight(Map context, Searcher searcher) throws IOException {
    }

    public static Map newContext() {
        return new IdentityHashMap();
    }

    public SortField getSortField(boolean reverse) throws IOException {
        return new ValueSourceSortField(reverse);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueSourceComparator
    extends FieldComparator<Double> {
        private final double[] values;
        private DocValues docVals;
        private double bottom;
        private Map fcontext;

        ValueSourceComparator(Map fcontext, int numHits) {
            this.fcontext = fcontext;
            this.values = new double[numHits];
        }

        public int compare(int slot1, int slot2) {
            double v1 = this.values[slot1];
            double v2 = this.values[slot2];
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        public int compareBottom(int doc) {
            double v2 = this.docVals.doubleVal(doc);
            if (this.bottom > v2) {
                return 1;
            }
            if (this.bottom < v2) {
                return -1;
            }
            return 0;
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.docVals.doubleVal(doc);
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.docVals = ValueSource.this.getValues(this.fcontext, reader);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public Double value(int slot) {
            return this.values[slot];
        }
    }

    class ValueSourceComparatorSource
    extends FieldComparatorSource {
        private final Map context;

        public ValueSourceComparatorSource(Map context) {
            this.context = context;
        }

        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new ValueSourceComparator(this.context, numHits);
        }
    }

    class ValueSourceSortField
    extends SortField
    implements SolrSortField {
        public ValueSourceSortField(boolean reverse) {
            super(ValueSource.this.description(), dummyComparator, reverse);
        }

        public SortField weight(IndexSearcher searcher) throws IOException {
            Map context = ValueSource.newContext();
            ValueSource.this.createWeight(context, (Searcher)searcher);
            return new SortField(this.getField(), (FieldComparatorSource)new ValueSourceComparatorSource(context), this.getReverse());
        }
    }
}

