/*
 * Decompiled with CFR 0.152.
 */
package javapns.devices;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javapns.devices.Device;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.PayloadPerDevice;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Devices {
    private static final int UNEFFICIENCY_THRESHOLD = 500;
    public static final Logger logger = Logger.getLogger(Devices.class);

    public static List<Device> asDevices(Object rawList) {
        Vector<Device> list = new Vector<Device>();
        if (rawList == null) {
            return list;
        }
        if (rawList instanceof List) {
            List devices = (List)rawList;
            if (devices == null || devices.size() == 0) {
                return list;
            }
            Object firstDevice = devices.get(0);
            if (firstDevice instanceof Device) {
                return devices;
            }
            if (firstDevice instanceof String) {
                for (Object token : devices) {
                    BasicDevice device = new BasicDevice();
                    device.setToken((String)token);
                    list.add(device);
                }
            }
        } else if (rawList instanceof String[]) {
            String[] tokens;
            for (String token : tokens = (String[])rawList) {
                BasicDevice device = new BasicDevice();
                device.setToken(token);
                list.add(device);
            }
        } else {
            if (rawList instanceof Device[]) {
                Device[] dvs = (Device[])rawList;
                return Arrays.asList(dvs);
            }
            if (rawList instanceof String) {
                BasicDevice device = new BasicDevice();
                device.setToken((String)rawList);
                list.add(device);
            } else if (rawList instanceof Device) {
                list.add((Device)rawList);
            } else {
                throw new IllegalArgumentException("Device list type not supported. Supported types are: String[], List<String>, Device[], List<Device>, String and Device");
            }
        }
        return list;
    }

    public static List<PayloadPerDevice> asPayloadsPerDevices(Object rawList) {
        Vector<PayloadPerDevice> list = new Vector<PayloadPerDevice>();
        if (rawList == null) {
            return list;
        }
        if (rawList instanceof List) {
            List devices = (List)rawList;
            if (devices == null || devices.size() == 0) {
                return list;
            }
            return devices;
        }
        if (rawList instanceof PayloadPerDevice[]) {
            PayloadPerDevice[] dvs = (PayloadPerDevice[])rawList;
            return Arrays.asList(dvs);
        }
        if (!(rawList instanceof PayloadPerDevice)) {
            throw new IllegalArgumentException("PayloadPerDevice list type not supported. Supported types are: PayloadPerDevice[], List<PayloadPerDevice> and PayloadPerDevice");
        }
        list.add((PayloadPerDevice)rawList);
        return list;
    }

    public static <T> void evaluateEfficiency(List<T> list) {
        int size = list.size();
        if (size > 500) {
            logger.warn((Object)("DEVICES WARNING: Pushing more than 500 notifications (your attempt: " + size + ") is not recommended with this method.\n You should consider using javapns.notification.transmission.NotificationThreads for increased reliability and efficiency."));
        }
    }
}

