/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2020 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ms.internal.portable;

import java.util.List;
import com.hazelcast.nio.serialization.Portable;
import com.openexchange.ms.Message;
import com.openexchange.ms.MessageListener;

/**
 * {@link PortableHzMessageListener}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 */
public class PortableHzMessageListener<P extends Portable> implements com.hazelcast.core.MessageListener<PortableMessage<P>> {

    private final MessageListener<P> listener;
    private final String senderID;

    /**
     * Initializes a new {@link PortableHzMessageListener}.
     *
     * @param listener The parent message listener
     * @param senderID The listener's sender ID
     */
    protected PortableHzMessageListener(MessageListener<P> listener, String senderID) {
        super();
        this.listener = listener;
        this.senderID = senderID;
    }

    @Override
    public void onMessage(com.hazelcast.core.Message<PortableMessage<P>> message) {
        PortableMessage<P> messageData = message.getMessageObject();
        List<P> messagePayload = messageData.getMessagePayload();
        if (null != messagePayload && 0 < messagePayload.size()) {
            String name = message.getSource().toString();
            String senderID = messageData.getSenderID();
            for (P payload : messagePayload) {
                listener.onMessage(new Message<P>(name, senderID, payload, !this.senderID.equals(senderID)));
            }
        }
    }

}
