/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.ho.util.Logger;
import org.ho.yaml.ListState;
import org.ho.yaml.MapState;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.YamlDecoder;
import org.ho.yaml.exception.YamlException;
import org.ho.yaml.wrapper.CollectionWrapper;
import org.ho.yaml.wrapper.MapWrapper;
import org.ho.yaml.wrapper.ObjectWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class State {
    Logger logger;
    YamlDecoder decoder;
    Map<String, ObjectWrapper> aliasMap;
    Stack<State> stack;
    ObjectWrapper wrapper;
    String declaredClassname;
    String anchorname;

    State(Map<String, ObjectWrapper> map, Stack<State> stack, YamlDecoder yamlDecoder, Logger logger) {
        this.aliasMap = map;
        this.stack = stack;
        this.decoder = yamlDecoder;
        this.logger = logger;
    }

    public void nextOnEvent(int n) {
        switch (n) {
            case 123: {
                this.openMap(this.stack);
                break;
            }
            case 91: {
                this.openList(this.stack);
                break;
            }
        }
    }

    public void nextOnContent(String string, String string2) {
    }

    public void nextOnProperty(String string, String string2) {
        if ("transfer".equals(string)) {
            if (this.getDeclaredClassname() == null && string2.startsWith("!")) {
                this.setDeclaredClassname(ReflectionUtil.transfer2classname(string2.substring(1), this.decoder.getConfig()));
            }
        } else if ("anchor".equals(string) && string2.startsWith("&")) {
            this.setAnchorname(string2.substring(1));
        }
    }

    public abstract void childCallback(ObjectWrapper var1);

    void clear() {
        this.setDeclaredClassname(null);
        this.setAnchorname(null);
    }

    ObjectWrapper createWrapper(String string) {
        ObjectWrapper objectWrapper = this.decoder.getConfig().getWrapper(this.expectedType());
        if (objectWrapper == null) {
            objectWrapper = this.decoder.getConfig().getWrapper(string);
        }
        return objectWrapper;
    }

    protected String expectedType(String string) {
        String string2 = this.expectedType();
        if (string2 == null && "string".equals(string)) {
            string2 = "java.lang.String";
        }
        return string2;
    }

    protected String expectedType() {
        return this.getClassname();
    }

    void openMap(Stack<State> stack) {
        ObjectWrapper objectWrapper = this.createWrapper(ReflectionUtil.className(HashMap.class));
        if (this.getAnchorname() != null) {
            this.markAnchor(objectWrapper, this.getAnchorname());
        }
        MapState mapState = new MapState(this.aliasMap, stack, this.decoder, this.logger);
        if (!(objectWrapper instanceof MapWrapper)) {
            throw new YamlException(objectWrapper.getObject() + " is not a Collection and so cannot be mapped from a sequence.");
        }
        mapState.wrapper = objectWrapper;
        stack.push(mapState);
    }

    void openList(Stack<State> stack) {
        ObjectWrapper objectWrapper = this.createWrapper(ReflectionUtil.className(ArrayList.class));
        if (this.getAnchorname() != null) {
            this.markAnchor(objectWrapper, this.getAnchorname());
        }
        ListState listState = new ListState(this.aliasMap, stack, this.decoder, this.logger);
        if (!(objectWrapper instanceof CollectionWrapper)) {
            throw new YamlException(objectWrapper.getObject() + " is not a Collection and so cannot be mapped from a sequence.");
        }
        listState.wrapper = objectWrapper;
        stack.push(listState);
    }

    void markAnchor(ObjectWrapper objectWrapper, String string) {
        if (this.aliasMap.get(string) == null) {
            this.aliasMap.put(string, objectWrapper);
        }
    }

    public ObjectWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(ObjectWrapper objectWrapper) {
        this.wrapper = objectWrapper;
    }

    public String getClassname() {
        return this.declaredClassname;
    }

    public String getDeclaredClassname() {
        return this.declaredClassname;
    }

    public void setDeclaredClassname(String string) {
        this.declaredClassname = string;
    }

    public String getAnchorname() {
        return this.anchorname;
    }

    public void setAnchorname(String string) {
        this.anchorname = string;
    }
}

