/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;

public class DestroyEndpointThreadsCallable
implements Callable<Boolean>,
HazelcastInstanceAware,
DataSerializable {
    private transient HazelcastInstance hazelcastInstance;
    private Address endpoint;
    private Set<Integer> threadIds;

    public DestroyEndpointThreadsCallable() {
    }

    public DestroyEndpointThreadsCallable(Address endpoint, Set<Integer> threadIds) {
        this.endpoint = endpoint;
        this.threadIds = threadIds;
    }

    public void addThreadId(int threadId) {
        this.threadIds.add(threadId);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public Boolean call() throws Exception {
        final ConcurrentMapManager c = this.getConcurrentMapManager(this.hazelcastInstance);
        c.enqueueAndWait(new Processable(){

            @Override
            public void process() {
                c.destroyEndpointThreads(DestroyEndpointThreadsCallable.this.endpoint, DestroyEndpointThreadsCallable.this.threadIds);
            }
        }, 10);
        return Boolean.TRUE;
    }

    private ConcurrentMapManager getConcurrentMapManager(HazelcastInstance h) {
        FactoryImpl factory = (FactoryImpl)h;
        return factory.node.concurrentMapManager;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        this.endpoint.writeData(out);
        int size = this.threadIds.size();
        out.writeInt(size);
        for (Integer threadId : this.threadIds) {
            out.writeInt(threadId);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.endpoint = new Address();
        this.endpoint.readData(in);
        int size = in.readInt();
        this.threadIds = new HashSet<Integer>(size);
        int i = 0;
        while (i < size) {
            this.addThreadId(in.readInt());
            ++i;
        }
    }
}

