/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ResponseHandler;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.nio.Address;

public final class ClientInvocationServiceImpl
implements ClientInvocationService {
    private final HazelcastClient client;

    public ClientInvocationServiceImpl(HazelcastClient client) {
        this.client = client;
    }

    public Object invokeOnRandomTarget(Object request) throws Exception {
        ClientClusterServiceImpl clusterService = this.getClusterService();
        return clusterService.sendAndReceive(request);
    }

    public Object invokeOnTarget(Object request, Address target) throws Exception {
        ClientClusterServiceImpl clusterService = this.getClusterService();
        return clusterService.sendAndReceive(target, request);
    }

    private ClientClusterServiceImpl getClusterService() {
        return (ClientClusterServiceImpl)this.client.getClientClusterService();
    }

    public Object invokeOnKeyOwner(Object request, Object key) throws Exception {
        ClientPartitionServiceImpl partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        Address owner = partitionService.getPartitionOwner(partitionService.getPartitionId(key));
        if (owner != null) {
            return this.invokeOnTarget(request, owner);
        }
        return this.invokeOnRandomTarget(request);
    }

    @Override
    public void invokeOnRandomTarget(Object request, ResponseHandler handler) throws Exception {
        ClientClusterServiceImpl clusterService = this.getClusterService();
        clusterService.sendAndHandle(request, handler);
    }

    @Override
    public void invokeOnTarget(Object request, Address target, ResponseHandler handler) throws Exception {
        ClientClusterServiceImpl clusterService = this.getClusterService();
        clusterService.sendAndHandle(target, request, handler);
    }

    @Override
    public void invokeOnKeyOwner(Object request, Object key, ResponseHandler handler) throws Exception {
        ClientPartitionServiceImpl partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        Address owner = partitionService.getPartitionOwner(partitionService.getPartitionId(key));
        if (owner != null) {
            this.invokeOnTarget(request, owner, handler);
        }
        this.invokeOnRandomTarget(request, handler);
    }
}

