/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.NaturalComparator;
import org.magicwerk.brownies.collections.primitive.LongGapList;

public class LongObjGapList
extends IList<Long> {
    LongGapList list;

    static Long[] toWrapper(long[] elems) {
        Long[] e = new Long[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static long[] toPrimitive(Long[] elems) {
        long[] e = new long[elems.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = elems[i];
        }
        return e;
    }

    static long[] toPrimitive(GapList<? extends Long> list2) {
        long[] e = new long[list2.size()];
        for (int i = 0; i < e.length; ++i) {
            e[i] = list2.get(i);
        }
        return e;
    }

    static long[] toPrimitive(Collection<? extends Long> list) {
        long[] e = new long[list.size()];
        Iterator<? extends Long> iter = list.iterator();
        for (int i = 0; i < e.length; ++i) {
            e[i] = iter.next();
        }
        return e;
    }

    public static LongObjGapList create() {
        return new LongObjGapList();
    }

    public static LongObjGapList create(int capacity) {
        return new LongObjGapList(capacity);
    }

    public static LongObjGapList create(Long ... elems) {
        return new LongObjGapList(elems);
    }

    public static LongObjGapList create(Collection<? extends Long> elems) {
        return new LongObjGapList(elems);
    }

    public LongObjGapList() {
        this.init();
    }

    public void init() {
        this.list = new LongGapList();
    }

    public LongObjGapList(int capacity) {
        this.init(capacity);
    }

    public void init(int capacity) {
        this.list = new LongGapList(capacity);
    }

    public LongObjGapList(Long ... elems) {
        this.init(elems);
    }

    public void init(Long ... elems) {
        this.list = new LongGapList(LongObjGapList.toPrimitive(elems));
    }

    public LongObjGapList(Collection<? extends Long> elems) {
        this.init(elems);
    }

    public void init(Collection<? extends Long> elems) {
        this.list = new LongGapList(LongObjGapList.toPrimitive(elems));
    }

    @Override
    protected void doClone(IList<Long> that) {
        this.list = (LongGapList)((LongObjGapList)that).list.clone();
    }

    @Override
    protected void doAssign(IList<Long> that) {
        LongObjGapList list = (LongObjGapList)that;
        this.list = list.list;
    }

    public LongObjGapList copy() {
        return (LongObjGapList)this.clone();
    }

    @Override
    public Long getDefaultElem() {
        return this.list.getDefaultElem();
    }

    @Override
    public IList<Long> doCreate(int capacity) {
        if (capacity == -1) {
            capacity = 10;
        }
        return new LongObjGapList(capacity);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public int capacity() {
        return this.list.capacity();
    }

    @Override
    public Long get(int index) {
        return this.list.get(index);
    }

    @Override
    protected Long doGet(int index) {
        return this.list.doGet(index);
    }

    @Override
    protected void doGetAll(Object[] elems, int index, int len) {
        this.list.doGetAll(LongObjGapList.toPrimitive((Long[])elems), index, len);
    }

    @Override
    protected boolean doAdd(int index, Long elem) {
        return this.list.doAdd(index, elem);
    }

    protected boolean doAddAll(int index, Long[] elem) {
        return this.list.doAddAll(index, LongObjGapList.toPrimitive(elem));
    }

    @Override
    protected Long doSet(int index, Long elem) {
        return this.list.doSet(index, elem);
    }

    protected void doSetAll(int index, Long[] elem) {
        this.list.doSetAll(index, LongObjGapList.toPrimitive(elem));
    }

    @Override
    protected Long doRemove(int index) {
        return this.list.doRemove(index);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        this.list.doRemoveAll(index, len);
    }

    @Override
    protected Long doReSet(int index, Long elem) {
        return this.list.doReSet(index, elem);
    }

    @Override
    public void move(int srcIndex, int dstIndex, int len) {
        this.list.move(srcIndex, dstIndex, len);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        this.list.doEnsureCapacity(minCapacity);
    }

    @Override
    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return -1;
        }
        return this.list.indexOf((Long)elem);
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return -1;
        }
        return this.list.lastIndexOf((Long)elem);
    }

    @Override
    public boolean remove(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        int index = this.list.indexOf((Long)elem);
        if (index == -1) {
            return false;
        }
        this.list.remove(index);
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        return this.list.contains((Long)elem);
    }

    @Override
    public boolean containsAny(Collection<?> coll) {
        return this.list.containsAny(coll);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.list.containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean removeAll(IList<?> coll) {
        return this.list.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public boolean retainAll(IList<?> coll) {
        return this.list.retainAll(coll);
    }

    @Override
    public Object[] toArray() {
        long[] elems = this.list.toArray();
        return LongObjGapList.toWrapper(elems);
    }

    @Override
    public Object[] toArray(int index, int len) {
        long[] elems = this.list.toArray(index, len);
        return LongObjGapList.toWrapper(elems);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.list.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            array[i] = this.list.get(i);
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    public boolean addAll(Collection<? extends Long> coll) {
        return this.list.addAll(coll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> coll) {
        return this.list.addAll(index, coll);
    }

    public boolean addAll(Long ... elems) {
        long[] e = LongObjGapList.toPrimitive(elems);
        return this.list.addAll(e);
    }

    public boolean addAll(int index, Long ... elems) {
        long[] e = LongObjGapList.toPrimitive(elems);
        return this.list.addAll(index, e);
    }

    @Override
    public boolean addAll(IList<? extends Long> list2) {
        long[] e = LongObjGapList.toPrimitive(list2);
        return this.list.addAll(e);
    }

    @Override
    public boolean addAll(int index, IList<? extends Long> list2) {
        long[] e = LongObjGapList.toPrimitive(list2);
        return this.list.addAll(index, e);
    }

    @Override
    public boolean removeFirstOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        return this.list.removeFirstOccurrence((Long)elem);
    }

    @Override
    public boolean removeLastOccurrence(Object elem) {
        if (elem == null || elem.getClass() != Long.class) {
            return false;
        }
        return this.list.removeLastOccurrence((Long)elem);
    }

    @Override
    public GapList<Long> getAll(int index, int len) {
        long[] elems = this.list.getArray(index, len);
        return GapList.create(LongObjGapList.toWrapper(elems));
    }

    public Long[] getArray(int index, int len) {
        long[] elems = this.list.getArray(index, len);
        return LongObjGapList.toWrapper(elems);
    }

    @Override
    public void setAll(int index, IList<? extends Long> list2) {
        long[] e = LongObjGapList.toPrimitive(list2);
        this.list.setAll(index, e);
    }

    @Override
    public void setAll(int index, Collection<? extends Long> coll) {
        long[] e = LongObjGapList.toPrimitive(coll);
        this.list.setAll(index, e);
    }

    public void setAll(int index, Long ... elems) {
        long[] e = LongObjGapList.toPrimitive(elems);
        this.list.setAll(index, e);
    }

    @Override
    public void sort(int index, int len, Comparator comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        this.list.sort(index, len);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        if (comparator != null && comparator != NaturalComparator.INSTANCE()) {
            throw new IllegalArgumentException("Only natural comparator (null) allowed");
        }
        return this.list.binarySearch(index, len, (Long)key);
    }

    public LongObjGapList unmodifiableList() {
        return new ImmutableLongObjGapList(this);
    }

    protected static class ImmutableLongObjGapList
    extends LongObjGapList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableLongObjGapList(LongObjGapList that) {
            super(that);
        }

        @Override
        protected boolean doAdd(int index, Long elem) {
            this.error();
            return false;
        }

        @Override
        protected boolean doAddAll(int index, Long[] elems) {
            this.error();
            return false;
        }

        @Override
        protected Long doSet(int index, Long elem) {
            this.error();
            return null;
        }

        @Override
        protected void doSetAll(int index, Long[] elems) {
            this.error();
        }

        @Override
        protected Long doReSet(int index, Long elem) {
            this.error();
            return null;
        }

        @Override
        protected Long doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

