/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import com.hazelcast.topic.TopicEvent;
import com.hazelcast.topic.TopicService;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.Lock;

public class PublishOperation
extends AbstractNamedOperation {
    private Data message;

    public PublishOperation() {
    }

    public PublishOperation(String name, Data message) {
        super(name);
        this.message = message;
    }

    @Override
    public void beforeRun() throws Exception {
        ((TopicService)this.getService()).incrementPublishes(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        TopicService service = (TopicService)this.getService();
        MemberImpl publishingMember = this.getNodeEngine().getClusterService().getMember(this.getCallerAddress());
        TopicEvent topicEvent = new TopicEvent(this.name, this.message, publishingMember);
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:topicService", this.name);
        Lock lock = service.getOrderLock(this.name);
        lock.lock();
        try {
            eventService.publishEvent("hz:impl:topicService", registrations, (Object)topicEvent, this.name.hashCode());
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.message.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.message = new Data();
        this.message.readData(in);
    }
}

