/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.concurrentmap.QueryException;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import com.hazelcast.query.SingleResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MapIndexService {
    private final ConcurrentMap<Long, Record> records = new ConcurrentHashMap<Long, Record>(10000, 0.75f, 1);
    private final Index indexValue;
    private final Map<Expression, Index> mapIndexes = new ConcurrentHashMap<Expression, Index>(4, 0.75f, 1);
    private final Object indexTypesLock = new Object();
    private volatile boolean hasIndexedAttributes = false;
    private volatile byte[] indexTypes = null;
    private final AtomicInteger size = new AtomicInteger(0);

    public MapIndexService(boolean valueIndexed) {
        this.indexValue = valueIndexed ? new Index(null, false, -1) : null;
    }

    public void remove(Record record) {
        Record existingRecord = (Record)this.records.remove(record.getId());
        if (existingRecord != null) {
            Long[] indexes = record.getIndexes();
            if (indexes != null && indexes.length > 0) {
                for (Index index : this.mapIndexes.values()) {
                    index.removeRecordIndex(indexes[index.getAttributeIndex()], record.getId());
                }
            }
            this.size.decrementAndGet();
        }
    }

    public void index(Record record) {
        Long[] indexValues;
        Long recordId = record.getId();
        if (record.isActive()) {
            Record anotherRecord = this.records.putIfAbsent(recordId, record);
            if (anotherRecord != null) {
                record = anotherRecord;
            } else {
                this.size.incrementAndGet();
            }
        } else {
            this.remove(record);
        }
        if (this.indexValue != null) {
            Long newValueIndex = -1L;
            if (record.isActive() && record.hasValueData()) {
                newValueIndex = record.getValueData().hashCode();
            }
            this.indexValue.index(newValueIndex, record);
        }
        if ((indexValues = record.getIndexes()) != null && this.hasIndexedAttributes) {
            byte[] indexTypes = record.getIndexTypes();
            if (indexTypes == null || indexValues.length != indexTypes.length) {
                throw new IllegalArgumentException("index and types don't match " + Arrays.toString(indexTypes));
            }
            Collection<Index> indexes = this.mapIndexes.values();
            for (Index index : indexes) {
                if (indexValues.length <= index.getAttributeIndex()) continue;
                Long newValue = indexValues[index.getAttributeIndex()];
                index.index(newValue, record);
            }
        }
    }

    public Collection<Record> getOwnedRecords() {
        return this.records.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] getIndexValues(Object value) {
        if (this.hasIndexedAttributes) {
            int indexCount = this.mapIndexes.size();
            Long[] newIndexes = new Long[indexCount];
            if (value instanceof Data) {
                value = IOUtil.toObject((Data)value);
            }
            Collection<Index> indexes = this.mapIndexes.values();
            for (Index index : indexes) {
                int attributedIndex = index.getAttributeIndex();
                newIndexes[attributedIndex] = index.extractLongValue(value);
            }
            byte[] _indexTypes = this.indexTypes;
            if (_indexTypes == null || _indexTypes.length != indexCount) {
                Object object = this.indexTypesLock;
                synchronized (object) {
                    _indexTypes = this.indexTypes;
                    if (_indexTypes == null || _indexTypes.length != indexCount) {
                        _indexTypes = new byte[indexCount];
                        for (Index index : indexes) {
                            int attributedIndex = index.getAttributeIndex();
                            _indexTypes[attributedIndex] = index.getIndexType();
                        }
                        this.indexTypes = _indexTypes;
                    }
                }
            }
            return newIndexes;
        }
        return null;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public Index addIndex(Expression expression, boolean ordered, int attributeIndex) {
        Index index = this.mapIndexes.get(expression);
        if (index == null) {
            if (this.size() > 0) {
                StringBuilder sb = new StringBuilder("Index can only be added before adding entries!");
                sb.append(" Add indexes first and only once then put entries.");
                throw new QueryException(sb.toString());
            }
            if (attributeIndex == -1) {
                attributeIndex = this.mapIndexes.size();
            }
            index = new Index(expression, ordered, attributeIndex);
            this.mapIndexes.put(expression, index);
            this.indexTypes = null;
            this.hasIndexedAttributes = true;
        }
        return index;
    }

    public Set<MapEntry> doQuery(QueryContext queryContext) {
        boolean strong = false;
        Predicate predicate = queryContext.getPredicate();
        try {
            if (predicate != null && this.mapIndexes != null && predicate instanceof IndexAwarePredicate) {
                int indexAwarePredicateCount;
                IndexAwarePredicate iap = (IndexAwarePredicate)predicate;
                ArrayList<IndexAwarePredicate> lsIndexAwarePredicates = new ArrayList<IndexAwarePredicate>();
                strong = iap.collectIndexAwarePredicates(lsIndexAwarePredicates, this.mapIndexes);
                if (strong) {
                    HashSet<Index> setAppliedIndexes = new HashSet<Index>(1);
                    iap.collectAppliedIndexes(setAppliedIndexes, this.mapIndexes);
                    if (setAppliedIndexes.size() > 0) {
                        for (Index index : setAppliedIndexes) {
                            if (!strong) continue;
                            strong = index.isStrong();
                        }
                    }
                }
                if ((indexAwarePredicateCount = lsIndexAwarePredicates.size()) == 1) {
                    IndexAwarePredicate indexAwarePredicate = (IndexAwarePredicate)lsIndexAwarePredicates.get(0);
                    Set<MapEntry> sub = indexAwarePredicate.filter(queryContext);
                    if (sub == null || sub.size() == 0) {
                        return null;
                    }
                    Set<MapEntry> set = sub;
                    return set;
                }
                if (indexAwarePredicateCount > 0) {
                    IndexAwarePredicate indexAwarePredicateFirst = (IndexAwarePredicate)lsIndexAwarePredicates.get(0);
                    Set<MapEntry> subFirst = indexAwarePredicateFirst.filter(queryContext);
                    if (subFirst != null && subFirst.size() < 11) {
                        strong = true;
                        HashSet<MapEntry> resultSet = new HashSet<MapEntry>(subFirst);
                        int i = 1;
                        while (i < lsIndexAwarePredicates.size()) {
                            IndexAwarePredicate p = (IndexAwarePredicate)lsIndexAwarePredicates.get(i);
                            Iterator it = resultSet.iterator();
                            while (it.hasNext()) {
                                Record record = (Record)it.next();
                                if (p.apply(record)) continue;
                                it.remove();
                            }
                            ++i;
                        }
                        HashSet<MapEntry> hashSet = resultSet;
                        return hashSet;
                    }
                    if (subFirst != null) {
                        ArrayList<Set> lsSubResults = new ArrayList<Set>(indexAwarePredicateCount);
                        lsSubResults.add(subFirst);
                        Set<MapEntry> smallestSet = subFirst;
                        int i = 1;
                        while (i < indexAwarePredicateCount) {
                            IndexAwarePredicate p = (IndexAwarePredicate)lsIndexAwarePredicates.get(i);
                            Set sub = p.filter(queryContext);
                            if (sub == null) {
                                strong = false;
                            } else {
                                if (sub.size() == 0) {
                                    strong = true;
                                    return null;
                                }
                                if (sub.size() < smallestSet.size()) {
                                    smallestSet = sub;
                                }
                                lsSubResults.add(sub);
                            }
                            ++i;
                        }
                        if (smallestSet == null) {
                            return null;
                        }
                        HashSet<MapEntry> results = new HashSet<MapEntry>(smallestSet.size());
                        block13: for (MapEntry entry : smallestSet) {
                            for (Set sub : lsSubResults) {
                                if (!sub.contains(entry)) continue block13;
                            }
                            results.add(entry);
                        }
                        HashSet<MapEntry> hashSet = results;
                        return hashSet;
                    }
                }
            }
            SingleResultSet singleResultSet = new SingleResultSet(this.records);
            return singleResultSet;
        }
        finally {
            queryContext.setStrong(strong);
        }
    }

    public Map<Expression, Index> getIndexes() {
        return this.mapIndexes;
    }

    public boolean hasIndexedAttributes() {
        return this.hasIndexedAttributes;
    }

    public Index getValueIndex() {
        return this.indexValue;
    }

    public Index[] getIndexesInOrder() {
        if (this.mapIndexes.size() == 0) {
            return null;
        }
        Index[] indexes = new Index[this.mapIndexes.size()];
        Iterator<Index> iterator = this.mapIndexes.values().iterator();
        while (iterator.hasNext()) {
            Index index;
            indexes[index.getAttributeIndex()] = index = iterator.next();
        }
        return indexes;
    }

    public void appendState(StringBuffer sbState) {
        byte[] _indexTypes = this.indexTypes;
        sbState.append("\nIndex- records: " + this.records.size() + ", mapIndexes:" + this.mapIndexes.size() + ", indexTypes:" + (_indexTypes == null ? 0 : _indexTypes.length));
        for (Index index : this.mapIndexes.values()) {
            index.appendState(sbState);
        }
    }

    public void clear() {
        this.mapIndexes.clear();
        this.records.clear();
        this.size.set(0);
    }

    public int size() {
        return this.size.get();
    }
}

