/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.management.ClusterRuntimeState;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class RuntimeStateRequest
implements ConsoleRequest,
Callable<ClusterRuntimeState>,
HazelcastInstanceAware {
    private static final long LOCK_TIME_THRESHOLD = TimeUnit.SECONDS.toMillis(300L);
    private transient HazelcastInstance hazelcastInstance;

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public ClusterRuntimeState call() throws Exception {
        FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
        return this.createState(factory);
    }

    private ClusterRuntimeState createState(FactoryImpl factory) {
        ClusterImpl cluster = factory.getCluster();
        PartitionManager pm = factory.node.concurrentMapManager.getPartitionManager();
        Collection<Record> lockedRecords = this.collectLockState(factory);
        return new ClusterRuntimeState(cluster.getMembers(), pm.getPartitions(), pm.getMigratingPartition(), factory.node.connectionManager.getReadonlyConnectionMap(), lockedRecords);
    }

    private Collection<Record> collectLockState(FactoryImpl factory) {
        LinkedList<String> mapNames = new LinkedList<String>();
        mapNames.add("c:__hz_Locks");
        for (Instance instance : factory.getInstances()) {
            if (!instance.getInstanceType().isMap()) continue;
            IMap imap = (IMap)instance;
            mapNames.add("c:" + imap.getName());
        }
        Node node = factory.node;
        LinkedList<Record> lockedRecords = new LinkedList<Record>();
        for (String mapName : mapNames) {
            CMap cmap = node.concurrentMapManager.getMap(mapName);
            if (cmap == null) continue;
            Collection<Record> records = cmap.getLockedRecordsFor(LOCK_TIME_THRESHOLD);
            lockedRecords.addAll(records);
        }
        return lockedRecords;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        ClusterRuntimeState clusterRuntimeState = this.createState(mcs.getHazelcastInstance());
        clusterRuntimeState.writeData(dos);
    }

    @Override
    public Object readResponse(DataInput in) throws IOException {
        ClusterRuntimeState clusterRuntimeState = new ClusterRuntimeState();
        clusterRuntimeState.readData(in);
        return clusterRuntimeState;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
    }

    @Override
    public void readData(DataInput in) throws IOException {
    }
}

