/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Keys
extends AbstractSet<Data>
implements DataSerializable {
    private Collection<Data> keys;

    public Keys() {
        this.keys = new ArrayList<Data>();
    }

    public Keys(Collection<Data> keys) {
        this.keys = keys;
    }

    public Collection<Data> getKeys() {
        return this.keys;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            Data data = new Data();
            data.readData(in);
            this.keys.add(data);
            ++i;
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        int size = this.keys == null ? 0 : this.keys.size();
        out.writeInt(size);
        if (size > 0) {
            for (Data key : this.keys) {
                key.writeData(out);
            }
        }
    }

    @Override
    public boolean add(Data data) {
        if (data == null) {
            return false;
        }
        this.keys.add(data);
        return true;
    }

    @Override
    public Iterator<Data> iterator() {
        return this.keys.iterator();
    }

    @Override
    public int size() {
        return this.keys.size();
    }
}

