/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.Executor;
import org.xsocket.IDataSink;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IWriteCompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface INonBlockingConnection
extends IConnection,
IDataSource,
IDataSink,
GatheringByteChannel,
ReadableByteChannel,
WritableByteChannel,
Flushable {
    public static final int UNLIMITED = Integer.MAX_VALUE;

    public void setHandler(IHandler var1) throws IOException;

    public IHandler getHandler();

    public String getEncoding();

    public void setEncoding(String var1);

    public void setAutoflush(boolean var1);

    public boolean isAutoflush();

    @Override
    public void flush() throws ClosedChannelException, IOException, SocketTimeoutException;

    public boolean isSecuredModeActivateable();

    public void activateSecuredMode() throws IOException;

    public boolean isSecure();

    public int getPendingWriteDataSize();

    public void suspendReceiving() throws IOException;

    public void resumeReceiving() throws IOException;

    public boolean isReceivingSuspended();

    public int write(String var1, String var2) throws IOException, BufferOverflowException;

    public void write(ByteBuffer[] var1, IWriteCompletionHandler var2) throws IOException;

    public void write(ByteBuffer var1, IWriteCompletionHandler var2) throws IOException;

    public void write(ByteBuffer[] var1, int var2, int var3, IWriteCompletionHandler var4) throws IOException;

    public void write(List<ByteBuffer> var1, IWriteCompletionHandler var2) throws IOException;

    public void write(byte[] var1, IWriteCompletionHandler var2) throws IOException;

    public void write(byte[] var1, int var2, int var3, IWriteCompletionHandler var4) throws IOException;

    public void write(String var1, String var2, IWriteCompletionHandler var3) throws IOException;

    public void unread(ByteBuffer[] var1) throws IOException;

    public void unread(ByteBuffer var1) throws IOException;

    public void unread(byte[] var1) throws IOException;

    public void unread(String var1) throws IOException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, MaxReadSizeExceededException;

    public byte[] readBytesByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException;

    public byte[] readBytesByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, MaxReadSizeExceededException;

    public String readStringByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByLength(int var1, String var2) throws IOException, BufferUnderflowException, UnsupportedEncodingException;

    @Override
    public long transferFrom(FileChannel var1) throws IOException, BufferOverflowException;

    public int indexOf(String var1) throws IOException;

    public int indexOf(String var1, String var2) throws IOException;

    public void setWriteTransferRate(int var1) throws ClosedChannelException, IOException;

    public int getWriteTransferRate() throws ClosedChannelException, IOException;

    public int available() throws IOException;

    public int getReadBufferVersion() throws IOException;

    @Override
    public boolean isOpen();

    public Executor getWorkerpool();

    public void setWorkerpool(Executor var1);

    public boolean resetToWriteMark();

    public boolean resetToReadMark();

    public void markWritePosition();

    public void markReadPosition();

    public void removeReadMark();

    public void removeWriteMark();

    public int getMaxReadBufferThreshold();

    public void setMaxReadBufferThreshold(int var1);

    public void setFlushmode(IConnection.FlushMode var1);

    public IConnection.FlushMode getFlushmode();
}

