/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class TrackFragmentBaseMediaDecodeTimeBox
extends AbstractFullBox {
    public static final String TYPE = "tfdt";
    private long baseMediaDecodeTime;

    public TrackFragmentBaseMediaDecodeTimeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return this.getVersion() == 0 ? 4L : 8L;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        if (this.getVersion() == 1) {
            os.writeUInt64(this.baseMediaDecodeTime);
        } else {
            os.writeUInt32(this.baseMediaDecodeTime);
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.baseMediaDecodeTime = this.getVersion() == 1 ? in.readUInt64() : in.readUInt32();
    }

    public long getBaseMediaDecodeTime() {
        return this.baseMediaDecodeTime;
    }

    public void setBaseMediaDecodeTime(long baseMediaDecodeTime) {
        this.baseMediaDecodeTime = baseMediaDecodeTime;
    }
}

