/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.Sprite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileFactoryDelegator
implements FtileFactory {
    private final FtileFactory factory;
    private final ISkinParam skinParam;
    private final Rose rose = new Rose();

    protected HtmlColor getInLinkRenderingColor(Ftile ftile) {
        LinkRendering linkRendering = ftile.getInLinkRendering();
        HtmlColor htmlColor = linkRendering == null || linkRendering.getColor() == null ? this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow) : linkRendering.getColor();
        return htmlColor;
    }

    protected Display getInLinkRenderingDisplay(Ftile ftile) {
        LinkRendering linkRendering = ftile.getInLinkRendering();
        if (linkRendering == null || linkRendering.getDisplay() == null) {
            return null;
        }
        return linkRendering.getDisplay();
    }

    public FtileFactoryDelegator(FtileFactory ftileFactory, ISkinParam iSkinParam) {
        this.factory = ftileFactory;
        this.skinParam = iSkinParam;
    }

    @Override
    public Ftile start(Swimlane swimlane) {
        return this.factory.start(swimlane);
    }

    @Override
    public Ftile stop(Swimlane swimlane) {
        return this.factory.stop(swimlane);
    }

    @Override
    public Ftile activity(Display display, HtmlColor htmlColor, Swimlane swimlane, BoxStyle boxStyle) {
        return this.factory.activity(display, htmlColor, swimlane, boxStyle);
    }

    @Override
    public Ftile addNote(Ftile ftile, Display display, NotePosition notePosition) {
        return this.factory.addNote(ftile, display, notePosition);
    }

    @Override
    public Ftile addUrl(Ftile ftile, Url url) {
        return this.factory.addUrl(ftile, url);
    }

    @Override
    public Ftile decorateIn(Ftile ftile, LinkRendering linkRendering) {
        return this.factory.decorateIn(ftile, linkRendering);
    }

    @Override
    public Ftile decorateOut(Ftile ftile, LinkRendering linkRendering) {
        return this.factory.decorateOut(ftile, linkRendering);
    }

    @Override
    public Ftile assembly(Ftile ftile, Ftile ftile2) {
        return this.factory.assembly(ftile, ftile2);
    }

    @Override
    public Ftile repeat(Swimlane swimlane, Ftile ftile, Display display, Display display2, Display display3, HtmlColor htmlColor) {
        return this.factory.repeat(swimlane, ftile, display, display2, display3, htmlColor);
    }

    @Override
    public Ftile createWhile(Swimlane swimlane, Ftile ftile, Display display, Display display2, Display display3, LinkRendering linkRendering, HtmlColor htmlColor) {
        return this.factory.createWhile(swimlane, ftile, display, display2, display3, linkRendering, htmlColor);
    }

    @Override
    public Ftile createIf(Swimlane swimlane, List<Branch> list, Branch branch) {
        return this.factory.createIf(swimlane, list, branch);
    }

    @Override
    public Ftile createFork(List<Ftile> list) {
        return this.factory.createFork(list);
    }

    @Override
    public Ftile createSplit(List<Ftile> list) {
        return this.factory.createSplit(list);
    }

    @Override
    public Ftile createGroup(Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2) {
        return this.factory.createGroup(ftile, display, htmlColor, htmlColor2);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.factory.getStringBounder();
    }

    protected final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    protected final Rose getRose() {
        return this.rose;
    }

    @Override
    public boolean shadowing() {
        return this.skinParam.shadowing();
    }

    protected FtileFactory getFactory() {
        return this.factory;
    }

    @Override
    public Sprite getSprite(String string) {
        return this.skinParam.getSprite(string);
    }

    @Override
    public String getValue(String string) {
        return this.skinParam.getValue(string);
    }
}

