/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.impl.ascii.rest.HttpCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpPostCommand;
import com.hazelcast.impl.ascii.rest.RestValue;
import com.hazelcast.impl.management.ManagementCenterService;
import java.net.URLDecoder;

public class HttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private static final byte[] QUEUE_SIMPLE_VALUE_CONTENT_TYPE = "text/plain".getBytes();

    public HttpPostCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpPostCommand command) {
        try {
            String uri = command.getURI();
            if (uri.startsWith("/hazelcast/rest/maps/")) {
                int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
                String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
                String key = uri.substring(indexEnd + 1);
                byte[] data = command.getData();
                this.textCommandService.put(mapName, key, new RestValue(data, command.getContentType()), 0);
                command.setResponse(HttpCommand.RES_204);
            } else if (uri.startsWith("/hazelcast/rest/mancenter/changeurl")) {
                if (this.textCommandService.getNode().getGroupProperties().MC_URL_CHANGE_ENABLED.getBoolean()) {
                    byte[] res = null;
                    byte[] data = command.getData();
                    String[] strList = new String(data).split("&");
                    String cluster = URLDecoder.decode(strList[0], "UTF-8");
                    String pass = URLDecoder.decode(strList[1], "UTF-8");
                    String url = URLDecoder.decode(strList[2], "UTF-8");
                    ManagementCenterService managementCenterService = this.textCommandService.getNode().getManagementCenterService();
                    if (managementCenterService != null) {
                        res = managementCenterService.changeWebServerUrlOverCluster(cluster, pass, url);
                    }
                    command.setResponse(res);
                } else {
                    command.setResponse(HttpCommand.RES_503);
                }
            } else if (uri.startsWith("/hazelcast/rest/queues/")) {
                byte[] contentType;
                byte[] data;
                String queueName = null;
                String simpleValue = null;
                String suffix = uri.endsWith("/") ? uri.substring("/hazelcast/rest/queues/".length(), uri.length() - 1) : uri.substring("/hazelcast/rest/queues/".length(), uri.length());
                int indexSlash = suffix.lastIndexOf("/");
                if (indexSlash == -1) {
                    queueName = suffix;
                } else {
                    queueName = suffix.substring(0, indexSlash);
                    simpleValue = suffix.substring(indexSlash + 1, suffix.length());
                }
                if (simpleValue == null) {
                    data = command.getData();
                    contentType = command.getContentType();
                } else {
                    data = simpleValue.getBytes();
                    contentType = QUEUE_SIMPLE_VALUE_CONTENT_TYPE;
                }
                boolean offerResult = this.textCommandService.offer(queueName, new RestValue(data, contentType));
                if (offerResult) {
                    command.setResponse(HttpCommand.RES_204);
                } else {
                    command.setResponse(HttpCommand.RES_503);
                }
            } else {
                command.setResponse(HttpCommand.RES_400);
            }
        }
        catch (Exception e) {
            command.setResponse(HttpCommand.RES_500);
        }
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpPostCommand command) {
        this.handle(command);
    }
}

