/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Member;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.partition.MigrationStatus;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.util.ResponseQueueFactory;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class PartitionServiceImpl
implements PartitionService {
    private final ILogger logger;
    private final ConcurrentMap<Integer, PartitionProxy> mapPartitions = new ConcurrentHashMap<Integer, PartitionProxy>();
    private final List<MigrationListener> lsMigrationListeners = new CopyOnWriteArrayList<MigrationListener>();
    private final ConcurrentMapManager concurrentMapManager;
    private final Set<Partition> partitions;

    public PartitionServiceImpl(ConcurrentMapManager concurrentMapManager) {
        this.logger = concurrentMapManager.node.getLogger(PartitionService.class.getName());
        this.concurrentMapManager = concurrentMapManager;
        this.partitions = new TreeSet<Partition>();
        int i = 0;
        while (i < concurrentMapManager.partitionCount) {
            PartitionProxy partitionProxy = new PartitionProxy(i);
            this.partitions.add(partitionProxy);
            this.mapPartitions.put(i, partitionProxy);
            ++i;
        }
    }

    public int getOwnedPartitionCount() {
        int currentCount = 0;
        for (Partition partition : this.partitions) {
            if (partition.getOwner() != null && !partition.getOwner().localMember()) continue;
            ++currentCount;
        }
        return currentCount;
    }

    @Override
    public Set<Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public PartitionProxy getPartition(Object key) {
        Data keyData = IOUtil.toData(key);
        int partitionId = this.concurrentMapManager.getPartitionId(keyData);
        return this.getPartition(partitionId);
    }

    public PartitionProxy getPartition(int partitionId) {
        return (PartitionProxy)this.mapPartitions.get(partitionId);
    }

    void doFireMigrationEvent(final MigrationStatus status, final MigrationEvent migrationEvent) {
        if (migrationEvent == null) {
            throw new IllegalArgumentException("MigrationEvent is null.");
        }
        if (status == MigrationStatus.COMPLETED) {
            this.concurrentMapManager.node.executorManager.executeNow(new Runnable(){

                @Override
                public void run() {
                    if (migrationEvent.getOldOwner() != null && migrationEvent.getOldOwner().localMember()) {
                        for (CMap cMap : ((PartitionServiceImpl)PartitionServiceImpl.this).concurrentMapManager.maps.values()) {
                            for (Record record : cMap.getMapIndexService().getOwnedRecords()) {
                                if (record.getBlockId() != migrationEvent.getPartitionId()) continue;
                                cMap.getMapIndexService().remove(record);
                            }
                        }
                    }
                }
            });
        }
        for (final MigrationListener migrationListener : this.lsMigrationListeners) {
            this.concurrentMapManager.node.executorManager.executeNow(new Runnable(){

                @Override
                public void run() {
                    switch (status) {
                        case STARTED: {
                            migrationListener.migrationStarted(migrationEvent);
                            break;
                        }
                        case COMPLETED: {
                            migrationListener.migrationCompleted(migrationEvent);
                            break;
                        }
                        case FAILED: {
                            migrationListener.migrationFailed(migrationEvent);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void addMigrationListener(MigrationListener migrationListener) {
        this.lsMigrationListeners.add(migrationListener);
    }

    @Override
    public void removeMigrationListener(MigrationListener migrationListener) {
        this.lsMigrationListeners.remove(migrationListener);
    }

    public void reset() {
    }

    boolean allPartitionsOwned() {
        Set<Partition> partitions = this.getPartitions();
        for (Partition partition : partitions) {
            if (partition.getOwner() != null) continue;
            return false;
        }
        return true;
    }

    private MemberImpl getPartitionOwner(final int partitionId) throws InterruptedException {
        final BlockingQueue responseQ = ResponseQueueFactory.newResponseQueue();
        this.concurrentMapManager.enqueueAndReturn(new Processable(){

            @Override
            public void process() {
                block6: {
                    MemberImpl memberOwner = null;
                    try {
                        try {
                            Address ownerAddress = PartitionServiceImpl.this.concurrentMapManager.getPartitionManager().getOwner(partitionId);
                            if (ownerAddress == null) break block6;
                            if (((PartitionServiceImpl)PartitionServiceImpl.this).concurrentMapManager.thisAddress.equals(ownerAddress)) {
                                memberOwner = ((PartitionServiceImpl)PartitionServiceImpl.this).concurrentMapManager.thisMember;
                                break block6;
                            }
                            memberOwner = PartitionServiceImpl.this.concurrentMapManager.getMember(ownerAddress);
                        }
                        catch (Exception e) {
                            PartitionServiceImpl.this.logger.log(Level.SEVERE, e.getMessage(), e);
                            responseQ.offer(memberOwner);
                        }
                    }
                    finally {
                        responseQ.offer(memberOwner);
                    }
                }
            }
        });
        return (MemberImpl)responseQ.poll(10L, TimeUnit.SECONDS);
    }

    class PartitionProxy
    implements Partition,
    Comparable {
        final int partitionId;

        PartitionProxy(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Member member;
            Address address = PartitionServiceImpl.this.concurrentMapManager.getPartitionManager().getPartition(this.partitionId).getOwner();
            if (address != null && (member = ((PartitionServiceImpl)PartitionServiceImpl.this).concurrentMapManager.node.getClusterImpl().getMember(address)) != null) {
                return member;
            }
            try {
                return PartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        public int compareTo(Object o) {
            PartitionProxy partition = (PartitionProxy)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionProxy partition = (PartitionProxy)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + this.getOwner();
        }
    }
}

