/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NearCacheConfig
implements DataSerializable {
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final int DEFAULT_MAX_IDLE_SECONDS = 0;
    public static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_EVICTION_POLICY = "LRU";
    private int timeToLiveSeconds = 0;
    private int maxSize = Integer.MAX_VALUE;
    private String evictionPolicy = "LRU";
    private int maxIdleSeconds = 0;
    private boolean invalidateOnChange = true;

    public NearCacheConfig(int timeToLiveSeconds, int maxSize, String evictionPolicy, int maxIdleSeconds, boolean invalidateOnChange) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.maxSize = maxSize;
        this.evictionPolicy = evictionPolicy;
        this.maxIdleSeconds = maxIdleSeconds;
        this.invalidateOnChange = invalidateOnChange;
    }

    public NearCacheConfig() {
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public NearCacheConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public NearCacheConfig setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public String getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public NearCacheConfig setEvictionPolicy(String evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public int getMaxIdleSeconds() {
        return this.maxIdleSeconds;
    }

    public NearCacheConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.maxIdleSeconds = maxIdleSeconds;
        return this;
    }

    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    public NearCacheConfig setInvalidateOnChange(boolean invalidateOnChange) {
        this.invalidateOnChange = invalidateOnChange;
        return this;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeInt(this.timeToLiveSeconds);
        out.writeInt(this.maxSize);
        out.writeBoolean(this.evictionPolicy == null);
        if (this.evictionPolicy != null) {
            out.writeUTF(this.evictionPolicy);
        }
        out.writeInt(this.maxIdleSeconds);
        out.writeBoolean(this.invalidateOnChange);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.timeToLiveSeconds = in.readInt();
        this.maxSize = in.readInt();
        boolean nullEvictionPolicy = in.readBoolean();
        this.evictionPolicy = !nullEvictionPolicy ? in.readUTF() : null;
        this.maxIdleSeconds = in.readInt();
        this.invalidateOnChange = in.readBoolean();
    }
}

