/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.javasimon.callback.async.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Executors {
    public static Executor DISABLED = new Executor(){

        public Object execute(Callable callable) throws Throwable {
            return null;
        }
    };
    public static Executor SYNC = new Executor(){

        public Object execute(Callable callable) throws Throwable {
            return callable.call();
        }
    };
    private static ExecutorService ASYNC_EXECUTOR_SERVICE;

    private static synchronized ExecutorService initAsyncExecutorService() {
        if (ASYNC_EXECUTOR_SERVICE == null) {
            ASYNC_EXECUTOR_SERVICE = java.util.concurrent.Executors.newSingleThreadExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "javasimon-async");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return ASYNC_EXECUTOR_SERVICE;
    }

    public static <T> Executor<T> disabled() {
        return DISABLED;
    }

    public static <T> Executor<T> sync() {
        return SYNC;
    }

    public static <T> Executor<T> async(ExecutorService executorService) {
        return new AsyncCallbackExecutor(executorService);
    }

    public static <T> Executor<T> async() {
        return Executors.async(Executors.initAsyncExecutorService());
    }

    public void shutdownAsync() {
        if (ASYNC_EXECUTOR_SERVICE != null) {
            ASYNC_EXECUTOR_SERVICE.shutdown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsyncCallbackExecutor<T>
    implements Executor<T> {
        private final ExecutorService executorService;

        public AsyncCallbackExecutor(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public T execute(Callable<T> callable) throws Throwable {
            this.executorService.submit(callable);
            return null;
        }
    }
}

