/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc4;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.javasimon.Counter;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.jdbc4.SimonCallableStatement;
import org.javasimon.jdbc4.SimonPreparedStatement;
import org.javasimon.jdbc4.SimonStatement;
import org.javasimon.jdbc4.WrapperSupport;

public final class SimonConnection
implements Connection {
    private final Connection conn;
    private final WrapperSupport<Connection> wrapperSupport;
    private String suffix;
    private Split life;
    private Counter commits;
    private Counter rollbacks;

    public SimonConnection(Connection conn, String prefix) {
        this.conn = conn;
        this.wrapperSupport = new WrapperSupport<Connection>(this.conn, Connection.class);
        this.suffix = prefix;
        this.commits = SimonManager.getCounter((String)(prefix + ".conn.commits"));
        this.rollbacks = SimonManager.getCounter((String)(prefix + ".conn.rollbacks"));
        this.life = SimonManager.getStopwatch((String)(prefix + ".conn")).start();
    }

    @Override
    public void close() throws SQLException {
        this.conn.close();
        this.life.stop();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
        this.commits.increase();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
        this.rollbacks.increase();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
        this.rollbacks.increase();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new SimonStatement(this, this.conn.createStatement(), this.suffix);
    }

    @Override
    public Statement createStatement(int rsType, int rsConcurrency) throws SQLException {
        return new SimonStatement(this, this.conn.createStatement(rsType, rsConcurrency), this.suffix);
    }

    @Override
    public Statement createStatement(int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        return new SimonStatement(this, this.conn.createStatement(rsType, rsConcurrency, rsHoldability), this.suffix);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new SimonPreparedStatement(this, this.conn.prepareStatement(sql), sql, this.suffix);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new SimonPreparedStatement(this, this.conn.prepareStatement(sql, autoGeneratedKeys), sql, this.suffix);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int rsType, int rsConcurrency) throws SQLException {
        return new SimonPreparedStatement(this, this.conn.prepareStatement(sql, rsType, rsConcurrency), sql, this.suffix);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        return new SimonPreparedStatement(this, this.conn.prepareStatement(sql, rsType, rsConcurrency, rsHoldability), sql, this.suffix);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new SimonPreparedStatement(this, this.conn.prepareStatement(sql, columnIndexes), sql, this.suffix);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new SimonPreparedStatement(this, this.conn.prepareStatement(sql, columnNames), sql, this.suffix);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return new SimonCallableStatement(this.conn, this.conn.prepareCall(sql), sql, this.suffix);
    }

    @Override
    public CallableStatement prepareCall(String sql, int rsType, int rsConcurrency) throws SQLException {
        return new SimonCallableStatement(this.conn, this.conn.prepareCall(sql, rsType, rsConcurrency), sql, this.suffix);
    }

    @Override
    public CallableStatement prepareCall(String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        return new SimonCallableStatement(this.conn, this.conn.prepareCall(sql, rsType, rsConcurrency, rsHoldability), sql, this.suffix);
    }

    @Override
    public String nativeSQL(String s) throws SQLException {
        return this.conn.nativeSQL(s);
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.conn.setAutoCommit(b);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
        this.conn.setReadOnly(b);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public void setCatalog(String s) throws SQLException {
        this.conn.setCatalog(s);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int i) throws SQLException {
        this.conn.setTransactionIsolation(i);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> stringClassMap) throws SQLException {
        this.conn.setTypeMap(stringClassMap);
    }

    @Override
    public void setHoldability(int i) throws SQLException {
        this.conn.setHoldability(i);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String s) throws SQLException {
        return this.conn.setSavepoint(s);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public boolean isValid(int i) throws SQLException {
        return this.conn.isValid(i);
    }

    @Override
    public void setClientInfo(String s, String s1) throws SQLClientInfoException {
        this.conn.setClientInfo(s, s1);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.conn.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String s) throws SQLException {
        return this.conn.getClientInfo(s);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String s, Object[] objects) throws SQLException {
        return this.conn.createArrayOf(s, objects);
    }

    @Override
    public Struct createStruct(String s, Object[] objects) throws SQLException {
        return this.conn.createStruct(s, objects);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.wrapperSupport.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.wrapperSupport.isWrapperFor(iface);
    }
}

