/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.XMLVersion;

public class ODUserDefinedMeta
extends ODNode {
    private static final String ELEM_NAME = "user-defined";
    private static final EnumSet<ODValueType> allowedTypes = EnumSet.of(ODValueType.FLOAT, ODValueType.DATE, ODValueType.TIME, ODValueType.BOOLEAN, ODValueType.STRING);
    private final ODXMLDocument parent;

    static ODUserDefinedMeta create(String string, ODXMLDocument oDXMLDocument) {
        Element element = new Element(ELEM_NAME, oDXMLDocument.getVersion().getMETA());
        element.setAttribute("name", string, oDXMLDocument.getVersion().getMETA());
        ODUserDefinedMeta oDUserDefinedMeta = new ODUserDefinedMeta(element, oDXMLDocument);
        oDUserDefinedMeta.setValue("");
        return oDUserDefinedMeta;
    }

    private static List<Element> getChildren(Element element, Namespace namespace) {
        return element.getChildren(ELEM_NAME, namespace);
    }

    static Element getElement(Element element, String string, XMLVersion xMLVersion) {
        Namespace namespace = xMLVersion.getMETA();
        for (Element element2 : ODUserDefinedMeta.getChildren(element, namespace)) {
            if (!string.equals(element2.getAttributeValue("name", namespace))) continue;
            return element2;
        }
        return null;
    }

    static List<String> getNames(Element element, XMLVersion xMLVersion) {
        Namespace namespace = xMLVersion.getMETA();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element2 : ODUserDefinedMeta.getChildren(element, namespace)) {
            arrayList.add(element2.getAttributeValue("name", namespace));
        }
        return arrayList;
    }

    ODUserDefinedMeta(Element element, ODXMLDocument oDXMLDocument) {
        super(element);
        this.parent = oDXMLDocument;
    }

    protected final ODXMLDocument getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.getElement().getAttributeValue("name", this.getNS().getMETA());
    }

    private final XMLVersion getNS() {
        return this.getParent().getVersion();
    }

    private final Attribute getValueTypeAttr() {
        return this.getValueTypeAttr(true);
    }

    private final Attribute getValueTypeAttr(boolean bl) {
        Attribute attribute = this.getElement().getAttribute("value-type", this.getNS().getMETA());
        if (attribute == null && bl) {
            attribute = new Attribute("value-type", ODValueType.STRING.getName(), this.getNS().getMETA());
            this.getElement().setAttribute(attribute);
        }
        return attribute;
    }

    public final Object getValue() {
        return this.getValueType().parse(this.getElement().getTextTrim());
    }

    public final ODValueType getValueType() {
        return ODValueType.get(this.getValueTypeAttr().getValue());
    }

    public final void setValue(Object object) {
        this.setValue(object, ODValueType.forObject(object));
    }

    public final void setValue(Object object, ODValueType oDValueType) {
        if (!allowedTypes.contains((Object)oDValueType)) {
            throw new IllegalArgumentException((Object)((Object)oDValueType) + " is not allowed: " + allowedTypes);
        }
        if (oDValueType != ODValueType.STRING) {
            this.getValueTypeAttr().setValue(oDValueType.getName());
        } else {
            Attribute attribute = this.getValueTypeAttr(false);
            if (attribute != null) {
                attribute.detach();
            }
        }
        this.getElement().setText(oDValueType.format(object));
    }
}

