/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TaggedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mail.MailContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RFC822Parser
extends AbstractParser {
    private static final long serialVersionUID = -5504243905998074168L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.parse("message/rfc822"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        MimeConfig config = new MimeConfig();
        config.setMaxLineLen(100000);
        config.setMaxHeaderLen(100000);
        config = context.get(MimeConfig.class, config);
        MimeStreamParser parser = new MimeStreamParser(config);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        MailContentHandler mch = new MailContentHandler(xhtml, metadata, context, config.isStrictParsing());
        parser.setContentHandler(mch);
        parser.setContentDecoding(true);
        TaggedInputStream tagged = TaggedInputStream.get(stream);
        try {
            parser.parse(tagged);
        }
        catch (IOException e) {
            tagged.throwIfCauseOf(e);
            throw new TikaException("Failed to parse an email message", e);
        }
        catch (MimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TikaException) {
                throw (TikaException)cause;
            }
            if (cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            throw new TikaException("Failed to parse an email message", e);
        }
    }
}

