/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.intl.chardet;

public class nsEUCSampler {
    int mTotal = 0;
    int mThreshold = 200;
    int mState = 0;
    public int[] mFirstByteCnt = new int[94];
    public int[] mSecondByteCnt = new int[94];
    public float[] mFirstByteFreq = new float[94];
    public float[] mSecondByteFreq = new float[94];

    public nsEUCSampler() {
        this.Reset();
    }

    public void Reset() {
        this.mTotal = 0;
        this.mState = 0;
        for (int i = 0; i < 94; ++i) {
            this.mSecondByteCnt[i] = 0;
            this.mFirstByteCnt[i] = 0;
        }
    }

    boolean EnoughData() {
        return this.mTotal > this.mThreshold;
    }

    boolean GetSomeData() {
        return this.mTotal > 1;
    }

    boolean Sample(byte[] byArray, int n) {
        if (this.mState == 1) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && 1 != this.mState) {
            switch (this.mState) {
                case 0: {
                    if ((byArray[n2] & 0x80) == 0) break;
                    if (255 == (0xFF & byArray[n2]) || 161 > (0xFF & byArray[n2])) {
                        this.mState = 1;
                        break;
                    }
                    ++this.mTotal;
                    int n4 = (0xFF & byArray[n2]) - 161;
                    this.mFirstByteCnt[n4] = this.mFirstByteCnt[n4] + 1;
                    this.mState = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if ((byArray[n2] & 0x80) != 0) {
                        if (255 == (0xFF & byArray[n2]) || 161 > (0xFF & byArray[n2])) {
                            this.mState = 1;
                            break;
                        }
                        ++this.mTotal;
                        int n5 = (0xFF & byArray[n2]) - 161;
                        this.mSecondByteCnt[n5] = this.mSecondByteCnt[n5] + 1;
                        this.mState = 0;
                        break;
                    }
                    this.mState = 1;
                    break;
                }
                default: {
                    this.mState = 1;
                }
            }
            ++n3;
            ++n2;
        }
        return 1 != this.mState;
    }

    void CalFreq() {
        for (int i = 0; i < 94; ++i) {
            this.mFirstByteFreq[i] = (float)this.mFirstByteCnt[i] / (float)this.mTotal;
            this.mSecondByteFreq[i] = (float)this.mSecondByteCnt[i] / (float)this.mTotal;
        }
    }

    float GetScore(float[] fArray, float f, float[] fArray2, float f2) {
        return f * this.GetScore(fArray, this.mFirstByteFreq) + f2 * this.GetScore(fArray2, this.mSecondByteFreq);
    }

    float GetScore(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < 94; ++i) {
            float f2 = fArray[i] - fArray2[i];
            f += f2 * f2;
        }
        return (float)Math.sqrt(f) / 94.0f;
    }
}

