/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.security.AbstractCredentials;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UsernamePasswordCredentials
extends AbstractCredentials {
    private static final long serialVersionUID = -1508314631354255039L;
    private byte[] password;

    public UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String username, String password) {
        super(username);
        this.password = password.getBytes();
    }

    public String getUsername() {
        return this.getPrincipal();
    }

    public byte[] getRawPassword() {
        return this.password;
    }

    public String getPassword() {
        return this.password == null ? "" : new String(this.password);
    }

    public void setUsername(String username) {
        this.setPrincipal(username);
    }

    public void setPassword(String password) {
        this.password = password.getBytes();
    }

    @Override
    public void writeDataInternal(DataOutput out) throws IOException {
        out.writeInt(this.password != null ? this.password.length : 0);
        if (this.password != null) {
            out.write(this.password);
        }
    }

    @Override
    public void readDataInternal(DataInput in) throws IOException {
        int s = in.readInt();
        if (s > 0) {
            this.password = new byte[s];
            in.readFully(this.password);
        }
    }

    public String toString() {
        return "UsernamePasswordCredentials [username=" + this.getUsername() + "]";
    }
}

