/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.MultiMap;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.IRemoveAwareProxy;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.nio.Data;
import com.hazelcast.query.Predicate;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Entries
extends AbstractSet {
    private final Collection<Map.Entry> colKeyValues;
    private final String name;
    private final ClusterOperation operation;
    private final boolean checkValue;
    private final ConcurrentMapManager concurrentMapManager;

    public Entries(ConcurrentMapManager concurrentMapManager, String name, ClusterOperation operation, Predicate predicate) {
        List<Map.Entry> entriesUnderTxn;
        this.concurrentMapManager = concurrentMapManager;
        this.name = name;
        this.operation = operation;
        this.colKeyValues = name.startsWith("m:u:") ? new LinkedList<Map.Entry>() : new HashSet<Map.Entry>();
        TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
        boolean bl = this.checkValue = Instance.InstanceType.MAP == BaseManager.getInstanceType(name) && (operation == ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES || operation == ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES);
        if (txn != null && (entriesUnderTxn = txn.newEntries(name)) != null) {
            if (predicate != null) {
                for (Map.Entry entry : entriesUnderTxn) {
                    if (!predicate.apply((MapEntry)entry)) continue;
                    this.colKeyValues.add(entry);
                }
            } else {
                this.colKeyValues.addAll(entriesUnderTxn);
            }
        }
    }

    @Override
    public int size() {
        return this.colKeyValues.size();
    }

    @Override
    public Iterator iterator() {
        return new EntryIterator(this.colKeyValues.iterator());
    }

    public void clearEntries() {
        this.colKeyValues.clear();
    }

    public void addEntries(Pairs pairs) {
        if (pairs == null) {
            return;
        }
        if (pairs.getKeyValues() == null) {
            return;
        }
        TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
        for (KeyValue entry : pairs.getKeyValues()) {
            if (txn != null) {
                Object key = entry.getKey();
                if (txn.has(this.name, key)) {
                    Data value = txn.get(this.name, key);
                    if (value == null) continue;
                    this.colKeyValues.add(BaseManager.createSimpleMapEntry(this.concurrentMapManager.node.factory, this.name, key, value));
                    continue;
                }
                entry.setName(this.concurrentMapManager.node.factory, this.name);
                this.colKeyValues.add(entry);
                continue;
            }
            entry.setName(this.concurrentMapManager.node.factory, this.name);
            this.colKeyValues.add(entry);
        }
    }

    public Collection<Map.Entry> getKeyValues() {
        return this.colKeyValues;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public Object[] toArray(Object[] a) {
        ArrayList values = new ArrayList();
        for (Object obj : this) {
            if (obj == null) continue;
            values.add(obj);
        }
        if (a == null) {
            return values.toArray();
        }
        return values.toArray(a);
    }

    class EntryIterator
    implements Iterator {
        final Iterator<Map.Entry> it;
        Map.Entry entry = null;
        boolean calledHasNext = false;
        boolean calledNext = false;
        boolean hasNext = false;

        public EntryIterator(Iterator<Map.Entry> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.calledHasNext && !this.calledNext) {
                return this.hasNext;
            }
            this.calledNext = false;
            this.calledHasNext = true;
            this.hasNext = this.setHasNext();
            return this.hasNext;
        }

        public boolean setHasNext() {
            if (!this.it.hasNext()) {
                return false;
            }
            this.entry = this.it.next();
            if (Entries.this.checkValue && this.entry.getValue() == null) {
                return this.hasNext();
            }
            return true;
        }

        public Object next() {
            if (!this.calledHasNext) {
                this.hasNext();
            }
            this.calledHasNext = false;
            this.calledNext = true;
            if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS || Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL) {
                return this.entry.getKey();
            }
            if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES) {
                return this.entry.getValue();
            }
            if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES) {
                return this.entry;
            }
            throw new RuntimeException("Unknown iteration type " + (Object)((Object)Entries.this.operation));
        }

        @Override
        public void remove() {
            if (BaseManager.getInstanceType(Entries.this.name) == Instance.InstanceType.MULTIMAP) {
                if (Entries.this.operation == ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS) {
                    ((MultiMap)((Entries)Entries.this).concurrentMapManager.node.factory.getOrCreateProxyByName(Entries.this.name)).remove(this.entry.getKey(), null);
                } else {
                    ((MultiMap)((Entries)Entries.this).concurrentMapManager.node.factory.getOrCreateProxyByName(Entries.this.name)).remove(this.entry.getKey(), this.entry.getValue());
                }
            } else {
                ((IRemoveAwareProxy)((Entries)Entries.this).concurrentMapManager.node.factory.getOrCreateProxyByName(Entries.this.name)).removeKey(this.entry.getKey());
            }
            this.it.remove();
        }
    }
}

