/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.ByteArrayInputOutputFactory;
import com.hazelcast.nio.serialization.ByteBufferInputOutputFactory;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.InputOutputFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.SerializerHookLoader;
import com.hazelcast.nio.serialization.UnsafeInputOutputFactory;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SerializationServiceBuilder {
    private ClassLoader classLoader;
    private SerializationConfig config;
    private int version = -1;
    private final Map<Integer, DataSerializableFactory> dataSerializableFactories = new HashMap<Integer, DataSerializableFactory>();
    private final Map<Integer, PortableFactory> portableFactories = new HashMap<Integer, PortableFactory>();
    private boolean checkClassDefErrors = true;
    private final Set<ClassDefinition> classDefinitions = new HashSet<ClassDefinition>();
    private ManagedContext managedContext;
    private boolean useNativeByteOrder = false;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean enableCompression = false;
    private boolean enableSharedObject = true;
    private boolean allowUnsafe = false;
    private int initialOutputBufferSize = 4096;
    private PartitioningStrategy partitioningStrategy;
    private HazelcastInstance hazelcastInstance;

    public SerializationServiceBuilder setVersion(int version) {
        if (version < 0) {
            throw new IllegalArgumentException("Version cannot be negative!");
        }
        this.version = version;
        return this;
    }

    public SerializationServiceBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SerializationServiceBuilder setConfig(SerializationConfig config) {
        this.config = config;
        if (this.version < 0) {
            this.version = config.getPortableVersion();
        }
        this.checkClassDefErrors = config.isCheckClassDefErrors();
        this.useNativeByteOrder = config.isUseNativeByteOrder();
        this.byteOrder = config.getByteOrder();
        this.enableCompression = config.isEnableCompression();
        this.enableSharedObject = config.isEnableSharedObject();
        this.allowUnsafe = config.isAllowUnsafe();
        return this;
    }

    public SerializationServiceBuilder addDataSerializableFactory(int id, DataSerializableFactory factory) {
        this.dataSerializableFactories.put(id, factory);
        return this;
    }

    public SerializationServiceBuilder addPortableFactory(int id, PortableFactory factory) {
        this.portableFactories.put(id, factory);
        return this;
    }

    public SerializationServiceBuilder addClassDefinition(ClassDefinition cd) {
        this.classDefinitions.add(cd);
        return this;
    }

    public SerializationServiceBuilder setCheckClassDefErrors(boolean checkClassDefErrors) {
        this.checkClassDefErrors = checkClassDefErrors;
        return this;
    }

    public SerializationServiceBuilder setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public SerializationServiceBuilder setUseNativeByteOrder(boolean useNativeByteOrder) {
        this.useNativeByteOrder = useNativeByteOrder;
        return this;
    }

    public SerializationServiceBuilder setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    public SerializationServiceBuilder setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        return this;
    }

    public SerializationServiceBuilder setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
        return this;
    }

    public SerializationServiceBuilder setEnableSharedObject(boolean enableSharedObject) {
        this.enableSharedObject = enableSharedObject;
        return this;
    }

    public SerializationServiceBuilder setAllowUnsafe(boolean allowUnsafe) {
        this.allowUnsafe = allowUnsafe;
        return this;
    }

    public SerializationServiceBuilder setPartitioningStrategy(PartitioningStrategy partitionStrategy) {
        this.partitioningStrategy = partitionStrategy;
        return this;
    }

    public SerializationServiceBuilder setInitialOutputBufferSize(int initialOutputBufferSize) {
        if (initialOutputBufferSize <= 0) {
            throw new IllegalArgumentException("Initial buffer size must be positive!");
        }
        this.initialOutputBufferSize = initialOutputBufferSize;
        return this;
    }

    public SerializationService build() {
        if (this.version < 0) {
            this.version = 0;
        }
        if (this.config != null) {
            this.addConfigDataSerializableFactories(this.dataSerializableFactories, this.config, this.classLoader);
            this.addConfigPortableFactories(this.portableFactories, this.config, this.classLoader);
            this.classDefinitions.addAll(this.config.getClassDefinitions());
        }
        InputOutputFactory inputOutputFactory = this.createInputOutputFactory();
        SerializationServiceImpl ss = new SerializationServiceImpl(inputOutputFactory, this.version, this.classLoader, this.dataSerializableFactories, this.portableFactories, this.classDefinitions, this.checkClassDefErrors, this.managedContext, this.partitioningStrategy, this.initialOutputBufferSize, this.enableCompression, this.enableSharedObject);
        SerializerHookLoader serializerHookLoader = new SerializerHookLoader(this.config, this.classLoader);
        Map<Class, Object> serializers = serializerHookLoader.getSerializers();
        for (Map.Entry<Class, Object> entry : serializers.entrySet()) {
            Class serializationType = entry.getKey();
            Object value = entry.getValue();
            Serializer serializer = value instanceof SerializerHook ? ((SerializerHook)value).createSerializer() : (Serializer)value;
            if (value instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)value).setHazelcastInstance(this.hazelcastInstance);
            }
            if (ClassLoaderUtil.isInternalType(value.getClass())) {
                ss.safeRegister(serializationType, serializer);
                continue;
            }
            ss.register(serializationType, serializer);
        }
        if (this.config != null && this.config.getGlobalSerializerConfig() != null) {
            GlobalSerializerConfig globalSerializerConfig = this.config.getGlobalSerializerConfig();
            Serializer serializer = globalSerializerConfig.getImplementation();
            if (serializer == null) {
                try {
                    serializer = (Serializer)ClassLoaderUtil.newInstance(this.classLoader, globalSerializerConfig.getClassName());
                }
                catch (Exception e) {
                    throw new HazelcastSerializationException(e);
                }
            }
            if (serializer instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)serializer)).setHazelcastInstance(this.hazelcastInstance);
            }
            ss.registerGlobal(serializer);
        }
        return ss;
    }

    private InputOutputFactory createInputOutputFactory() {
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        }
        if (this.useNativeByteOrder || this.byteOrder == ByteOrder.nativeOrder()) {
            this.byteOrder = ByteOrder.nativeOrder();
            if (this.allowUnsafe && UnsafeInputOutputFactory.unsafeAvailable()) {
                return new UnsafeInputOutputFactory();
            }
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return new ByteArrayInputOutputFactory();
        }
        return new ByteBufferInputOutputFactory(this.byteOrder);
    }

    private void addConfigDataSerializableFactories(Map<Integer, DataSerializableFactory> dataSerializableFactories, SerializationConfig config, ClassLoader cl) {
        Integer factoryId;
        for (Map.Entry<Integer, DataSerializableFactory> entry : config.getDataSerializableFactories().entrySet()) {
            factoryId = entry.getKey();
            DataSerializableFactory factory = entry.getValue();
            if (factoryId <= 0) {
                throw new IllegalArgumentException("DataSerializableFactory factoryId must be positive! -> " + factory);
            }
            if (dataSerializableFactories.containsKey(factoryId)) {
                throw new IllegalArgumentException("DataSerializableFactory with factoryId '" + factoryId + "' is already registered!");
            }
            dataSerializableFactories.put(factoryId, factory);
        }
        for (Map.Entry<Integer, Object> entry : config.getDataSerializableFactoryClasses().entrySet()) {
            DataSerializableFactory factory;
            factoryId = entry.getKey();
            String factoryClassName = (String)entry.getValue();
            if (factoryId <= 0) {
                throw new IllegalArgumentException("DataSerializableFactory factoryId must be positive! -> " + factoryClassName);
            }
            if (dataSerializableFactories.containsKey(factoryId)) {
                throw new IllegalArgumentException("DataSerializableFactory with factoryId '" + factoryId + "' is already registered!");
            }
            try {
                factory = (DataSerializableFactory)ClassLoaderUtil.newInstance(cl, factoryClassName);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
            dataSerializableFactories.put(factoryId, factory);
        }
        for (DataSerializableFactory dataSerializableFactory : dataSerializableFactories.values()) {
            if (!(dataSerializableFactory instanceof HazelcastInstanceAware)) continue;
            ((HazelcastInstanceAware)((Object)dataSerializableFactory)).setHazelcastInstance(this.hazelcastInstance);
        }
    }

    private void addConfigPortableFactories(Map<Integer, PortableFactory> portableFactories, SerializationConfig config, ClassLoader cl) {
        for (Map.Entry<Integer, PortableFactory> entry : config.getPortableFactories().entrySet()) {
            Integer factoryId = entry.getKey();
            PortableFactory factory = entry.getValue();
            if (factoryId <= 0) {
                throw new IllegalArgumentException("PortableFactory factoryId must be positive! -> " + factory);
            }
            if (portableFactories.containsKey(factoryId)) {
                throw new IllegalArgumentException("PortableFactory with factoryId '" + factoryId + "' is already registered!");
            }
            portableFactories.put(factoryId, factory);
        }
        Map<Integer, String> portableFactoryClasses = config.getPortableFactoryClasses();
        for (Map.Entry<Integer, String> entry : portableFactoryClasses.entrySet()) {
            PortableFactory factory;
            Integer factoryId = entry.getKey();
            String factoryClassName = entry.getValue();
            if (factoryId <= 0) {
                throw new IllegalArgumentException("PortableFactory factoryId must be positive! -> " + factoryClassName);
            }
            if (portableFactories.containsKey(factoryId)) {
                throw new IllegalArgumentException("PortableFactory with factoryId '" + factoryId + "' is already registered!");
            }
            try {
                factory = (PortableFactory)ClassLoaderUtil.newInstance(cl, factoryClassName);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
            portableFactories.put(factoryId, factory);
        }
        for (PortableFactory f : portableFactories.values()) {
            if (!(f instanceof HazelcastInstanceAware)) continue;
            ((HazelcastInstanceAware)((Object)f)).setHazelcastInstance(this.hazelcastInstance);
        }
    }
}

