/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations.client;

import com.hazelcast.client.RetryableRequest;
import com.hazelcast.multimap.operations.MultiMapOperationFactory;
import com.hazelcast.multimap.operations.MultiMapResponse;
import com.hazelcast.multimap.operations.client.MultiMapAllPartitionRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.PortableCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class KeySetRequest
extends MultiMapAllPartitionRequest
implements RetryableRequest {
    public KeySetRequest() {
    }

    public KeySetRequest(String name) {
        super(name);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.KEY_SET);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Data> keySet = new HashSet<Data>();
        for (Object obj : map.values()) {
            MultiMapResponse response;
            Collection coll;
            if (obj == null || (coll = (response = (MultiMapResponse)obj).getCollection()) == null) continue;
            keySet.addAll(coll);
        }
        return new PortableCollection(keySet);
    }

    @Override
    public int getClassId() {
        return 7;
    }
}

