/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.MapEntrySimple;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultipleEntryBackupOperation
extends AbstractMapOperation
implements BackupOperation,
PartitionAwareOperation {
    private Set<Data> keys;
    private EntryBackupProcessor backupProcessor;

    public MultipleEntryBackupOperation() {
    }

    public MultipleEntryBackupOperation(String name, Set<Data> keys, EntryBackupProcessor backupProcessor) {
        super(name);
        this.backupProcessor = backupProcessor;
        this.keys = keys;
    }

    @Override
    public void run() throws Exception {
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        RecordStore recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
        for (Data key : this.keys) {
            if (partitionService.getPartitionId(key) != this.getPartitionId()) continue;
            Object objectKey = this.mapService.toObject(key);
            Map.Entry<Data, Object> mapEntry = recordStore.getMapEntry(key);
            Object valueBeforeProcess = this.mapService.toObject(mapEntry.getValue());
            MapEntrySimple<Object, Object> entry = new MapEntrySimple<Object, Object>(objectKey, valueBeforeProcess);
            this.backupProcessor.processBackup(entry);
            if (!entry.isModified()) continue;
            if (entry.getValue() == null) {
                recordStore.deleteRecord(key);
                continue;
            }
            recordStore.putBackup(key, entry.getValue());
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.backupProcessor = (EntryBackupProcessor)in.readObject();
        int size = in.readInt();
        this.keys = new HashSet<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data key = new Data();
            key.readData(in);
            this.keys.add(key);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.backupProcessor);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            key.writeData(out);
        }
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "MultipleEntryBackupOperation{}";
    }
}

