/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference.client;

import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.atomicreference.client.AtomicReferencePortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.AtomicReferencePermission;
import java.io.IOException;
import java.security.Permission;

public abstract class ReadRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    protected String name;

    public ReadRequest() {
    }

    public ReadRequest(String name) {
        this.name = name;
    }

    @Override
    protected int getPartition() {
        ClientEngine clientEngine = this.getClientEngine();
        Data key = clientEngine.getSerializationService().toData(this.name);
        return clientEngine.getPartitionService().getPartitionId(key);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicReferenceService";
    }

    @Override
    public int getFactoryId() {
        return AtomicReferencePortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new AtomicReferencePermission(this.name, "read");
    }
}

